/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.gnuplot.AbstractScriptlet;
import adams.core.option.OptionHandler;

public class Pause
extends AbstractScriptlet {
    private static final long serialVersionUID = -3540923217777778401L;
    public static final String TERMINAL_X11 = "x11";
    protected int m_WaitingPeriod;
    protected String m_Message;

    public String globalInfo() {
        return "Inserts a pause statement to keep the plot open; the use needs to press the enter key in the terminal to close the plot.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("waiting-period", "waitingPeriod", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("message", "message", (Object)"");
    }

    public void setWaitingPeriod(int value) {
        this.m_WaitingPeriod = value;
        this.reset();
    }

    public int getWaitingPeriod() {
        return this.m_WaitingPeriod;
    }

    public String waitingPeriodTipText() {
        return "The waiting period in seconds before closing the plot automatically; use -1 to keep open indefinitely.";
    }

    public void setMessage(String value) {
        this.m_Message = value;
        this.reset();
    }

    public String getMessage() {
        return this.m_Message;
    }

    public String messageTipText() {
        return "The message to output in the terminal when pausing, ignored if empty.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"waitingPeriod", (Object)this.m_WaitingPeriod, (String)"wait: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"message", (Object)this.m_Message, (String)", msg: ");
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("pause " + this.m_WaitingPeriod);
        if (this.m_Message.length() > 0) {
            result.append(" \"" + Utils.backQuoteChars((String)this.m_Message) + "\"");
        }
        result.append("\n");
        return result.toString();
    }
}

