/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReaderWithMissingValueSupport;
import adams.data.io.output.GnuplotSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import java.io.File;
import java.util.List;

public class GnuplotSpreadSheetReader
extends AbstractSpreadSheetReaderWithMissingValueSupport {
    private static final long serialVersionUID = 2126554583457852066L;
    public static final String COMMENT = "#";
    public static final String MISSING_VALUE = "-999";

    public String globalInfo() {
        return "Reads data in Gnuplot format.";
    }

    public String getFormatDescription() {
        return "Gnuplot data";
    }

    public String[] getFormatExtensions() {
        return new String[]{"dat", "data"};
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new GnuplotSpreadSheetWriter();
    }

    protected BaseRegExp getDefaultMissingValue() {
        return new BaseRegExp(MISSING_VALUE);
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    protected SpreadSheet doRead(File file) {
        List lines = FileUtils.loadFromFile((File)file, (String)this.getEncoding().stringValue());
        if (lines == null) {
            return null;
        }
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        boolean first = true;
        for (String line : lines) {
            int i;
            HeaderRow row;
            if (this.m_Stopped) break;
            if (line.startsWith(COMMENT)) {
                result.addComment(line.substring(COMMENT.length()));
                continue;
            }
            String[] cells = line.split("\\s+");
            if (first) {
                row = result.getHeaderRow();
                for (i = 0; i < cells.length; ++i) {
                    row.addCell("" + i).setContent("Col" + (i + 1));
                }
                first = false;
            }
            row = result.addRow();
            for (i = 0; i < cells.length && i < result.getColumnCount(); ++i) {
                Cell cell = row.addCell("" + i);
                if (this.m_MissingValue.isMatch(cells[i]) || cells[i].isEmpty() && this.m_MissingValue.isEmpty()) {
                    cell.setMissing();
                    continue;
                }
                cell.setContent(cells[i]);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        GnuplotSpreadSheetReader.runReader(Environment.class, GnuplotSpreadSheetReader.class, (String[])args);
    }
}

