/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Range;
import adams.core.Utils;
import adams.core.management.User;
import adams.data.io.input.GnuplotSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.AbstractSpreadSheetWriterWithMissingValueSupport;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import java.io.Writer;
import java.util.logging.Level;

public class GnuplotSpreadSheetWriter
extends AbstractSpreadSheetWriterWithMissingValueSupport
implements AppendableSpreadSheetWriter {
    private static final long serialVersionUID = -1298185600402768643L;
    protected Range m_Columns;
    protected boolean m_Appending;
    protected SpreadSheet m_Header;
    protected boolean m_KeepExisting;
    protected boolean[] m_IsNumeric;
    protected boolean m_FileExists;

    public String globalInfo() {
        return "Outputs all numeric columns of a spreadsheet in Gnuplot format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new Range("first-last"));
        this.m_OptionManager.add("invert", "invert", (Object)false);
        this.m_OptionManager.add("appending", "appending", (Object)false);
        this.m_OptionManager.add("keep-existing", "keepExisting", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    public void reset() {
        super.reset();
        this.m_Header = null;
        this.m_FileExists = false;
    }

    public String getFormatDescription() {
        return new GnuplotSpreadSheetReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new GnuplotSpreadSheetReader().getFormatExtensions();
    }

    public SpreadSheetReader getCorrespondingReader() {
        return new GnuplotSpreadSheetReader();
    }

    protected String getDefaultMissingValue() {
        return "-999";
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns in the spreadsheet to output.";
    }

    public void setInvert(boolean value) {
        this.m_Columns.setInverted(value);
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Columns.isInverted();
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    public boolean canAppend(SpreadSheet sheet) {
        if (this.m_Header == null) {
            return this.m_KeepExisting;
        }
        return this.m_Header.equalsHeader(sheet) == null;
    }

    public void setAppending(boolean value) {
        this.m_Appending = value;
        this.reset();
    }

    public boolean isAppending() {
        return this.m_Appending;
    }

    public String appendingTipText() {
        return "If enabled, multiple spreadsheets with the same structure can be written to the same file.";
    }

    public void setKeepExisting(boolean value) {
        this.m_KeepExisting = value;
        this.reset();
    }

    public boolean getKeepExisting() {
        return this.m_KeepExisting;
    }

    public String keepExistingTipText() {
        return "If enabled, any output file that exists when the writer is executed for the first time won't get replaced with the current header; useful when outputting data in multiple locations in the flow, but one needs to be cautious as to not stored mixed content (eg varying number of columns, etc).";
    }

    public void setFileExists(boolean value) {
        this.m_FileExists = value;
    }

    public boolean getFileExists() {
        return this.m_FileExists;
    }

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.WRITER;
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        boolean result = true;
        try {
            Cell cell;
            int i;
            boolean first;
            String newline = System.getProperty("line.separator");
            this.m_Columns.setMax(content.getColumnCount());
            int[] indices = this.m_Columns.getIntIndices();
            if (this.m_Header == null) {
                this.m_IsNumeric = new boolean[indices.length];
                first = true;
                for (i = 0; i < this.m_IsNumeric.length; ++i) {
                    this.m_IsNumeric[i] = content.isNumeric(indices[i]);
                    if (!this.m_IsNumeric[i]) continue;
                    first = false;
                }
                if (first) {
                    return false;
                }
                if (!this.m_FileExists || !this.m_KeepExisting) {
                    writer.write("# Project: " + Environment.getInstance().getProject() + newline);
                    writer.write("# User: " + User.getName() + newline);
                    writer.write("#" + newline);
                    if (content.hasName()) {
                        writer.write("# " + content.getName() + newline);
                        writer.write("#" + newline);
                    }
                    if (content.getComments().size() > 0) {
                        for (i = 0; i < content.getComments().size(); ++i) {
                            writer.write("# " + (String)content.getComments().get(i) + newline);
                        }
                        writer.write("#" + newline);
                    }
                    first = true;
                    for (i = 0; i < indices.length; ++i) {
                        cell = content.getHeaderRow().getCell(indices[i]);
                        if (!this.m_IsNumeric[i]) continue;
                        if (first) {
                            writer.write("# ");
                        } else {
                            writer.write("\t");
                        }
                        if (cell.isMissing()) {
                            writer.write(Utils.doubleQuote((String)this.m_MissingValue));
                        } else {
                            writer.write(Utils.doubleQuote((String)cell.getContent()));
                        }
                        first = false;
                    }
                    writer.write(newline);
                }
                if (this.m_Appending) {
                    this.m_Header = content.getHeader();
                }
            }
            HeaderRow header = content.getHeaderRow();
            for (DataRow row : content.rows()) {
                if (this.m_Stopped) {
                    return false;
                }
                first = true;
                for (i = 0; i < indices.length; ++i) {
                    String colName = header.getCellKey(indices[i]);
                    cell = row.getCell(colName);
                    if (!this.m_IsNumeric[i]) continue;
                    if (!first) {
                        writer.write("\t");
                    }
                    if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                        writer.write(Utils.doubleQuote((String)cell.getContent()));
                    } else {
                        writer.write(Utils.doubleQuote((String)this.m_MissingValue));
                    }
                    first = false;
                }
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", (Throwable)e);
        }
        return result;
    }
}

