/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;

public class Gnuplot
extends AbstractStandalone {
    private static final long serialVersionUID = -1977229579470423891L;
    protected String m_Binary;
    protected PlaceholderFile m_ScriptFile;
    protected transient CollectingProcessOutput m_ProcessOutput;

    public String globalInfo() {
        return "Executes Gnuplot with the specified script file.\n\nNB: Add the absolute path to the binary, if gnuplot is not on the system's path.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("binary", "binary", (Object)"gnuplot");
        this.m_OptionManager.add("script-file", "scriptFile", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"binary", (Object)this.m_Binary);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)this.m_ScriptFile, (String)" ");
        return result;
    }

    public void setBinary(String value) {
        this.m_Binary = value;
        this.reset();
    }

    public String getBinary() {
        return this.m_Binary;
    }

    public String binaryTipText() {
        return "The Gnuplot binary to execute; use absolute path if not on system's path.";
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to execute.";
    }

    protected String doExecute() {
        Object result = null;
        if (this.isHeadless()) {
            return result;
        }
        if (!this.m_ScriptFile.exists()) {
            result = "Script file '" + this.m_ScriptFile + "' does not exist!";
            return result;
        }
        String[] cmd = new String[]{this.m_Binary, this.m_ScriptFile.getAbsolutePath()};
        try {
            this.m_ProcessOutput = ProcessUtils.execute((String[])cmd);
            if (!this.m_ProcessOutput.hasSucceeded()) {
                result = ProcessUtils.toErrorOutput((CollectingProcessOutput)this.m_ProcessOutput);
            } else {
                this.getLogger().severe(this.m_ProcessOutput.getStdErr());
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to run Gnuplot with script '" + this.m_ScriptFile + "':", e);
        }
        this.m_ProcessOutput = null;
        return result;
    }

    public void stopExecution() {
        if (this.m_ProcessOutput != null) {
            this.m_ProcessOutput.destroy();
        }
        super.stopExecution();
    }
}

