/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.core.scripting.Groovy;
import adams.flow.core.Actor;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;

public class GroovyPlugin
extends AbstractOptionHandler
implements FileBasedScriptingWithOptions,
QuickInfoSupporter {
    private static final long serialVersionUID = -3914295307329929706L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;

    public String globalInfo() {
        return "Wrapper for a REST plugin written in Groovy.\nLoads the script file and applies the supplied options.\nRequires the class in the Groovy script to implement the " + Utils.classToString(AdditionalOptionsHandler.class) + " interface.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", (Object)new BaseText());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"scriptFile", (Object)(this.m_ScriptFile + " " + this.m_ScriptOptions).trim(), null);
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(BaseText value) {
        this.m_ScriptOptions = value.getValue();
        this.reset();
    }

    public BaseText getScriptOptions() {
        return new BaseText(this.m_ScriptOptions);
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    public Object loadPlugin(Actor context) throws Exception {
        Object result = Groovy.getSingleton().newInstance((File)this.m_ScriptFile, Object.class);
        if (!(result instanceof AdditionalOptionsHandler)) {
            throw new Exception("Script has to implement " + Utils.classToString(AdditionalOptionsHandler.class) + " in order to set the options!");
        }
        AdditionalOptionsHandlerUtils.setOptions((Object)result, (String)this.m_ScriptOptions, (Variables)context.getVariables());
        return result;
    }
}

