/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingLevelHandler;
import adams.core.scripting.Groovy;
import adams.flow.core.FlowContextHandler;
import adams.flow.rest.AbstractRESTPlugin;
import adams.flow.rest.AbstractRESTProvider;
import adams.flow.rest.GroovyPlugin;
import adams.flow.rest.RESTPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;

public class GroovyServer
extends AbstractRESTProvider {
    private static final long serialVersionUID = 6759800194384027943L;
    protected PlaceholderFile[] m_UnparametrizedScripts;
    protected GroovyPlugin[] m_ParametrizedScripts;

    public String globalInfo() {
        return "GenericREST service provider, which allows you to assemble the REST plugins that should make up the service from Groovy scripts.\n\nUnparametrized scripts:\nScripts either need to implement " + Utils.classToString(RESTPlugin.class) + " interface or be derived from the " + Utils.classToString(AbstractRESTPlugin.class) + " superclass.\nAutomatically sets the flow context of plugins, if they should implement the " + Utils.classToString(FlowContextHandler.class) + " interface.\nIf implementing the " + Utils.classToString(LoggingLevelHandler.class) + " interface, they plugin receives the same logging level as this server.\n\nParametrized scripts:\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("unparametrized-script", "unparametrizedScripts", (Object)new PlaceholderFile[0]);
        this.m_OptionManager.add("parametrized-script", "parametrizedScripts", (Object)new GroovyPlugin[0]);
    }

    public void setUnparametrizedScripts(PlaceholderFile[] value) {
        this.m_UnparametrizedScripts = value;
        this.reset();
    }

    public PlaceholderFile[] getUnparametrizedScripts() {
        return this.m_UnparametrizedScripts;
    }

    public String unparametrizedScriptsTipText() {
        return "The (non-parametrized) Groovy scripts that make up the REST service.";
    }

    public void setParametrizedScripts(GroovyPlugin[] value) {
        this.m_ParametrizedScripts = value;
        this.reset();
    }

    public GroovyPlugin[] getParametrizedScripts() {
        return this.m_ParametrizedScripts;
    }

    public String parametrizedScriptsTipText() {
        return "The (parametrized) Groovy scripts that make up the REST service.";
    }

    public String getDefaultURL() {
        return "http://localhost:8080/";
    }

    protected Object[] loadPlugins() throws Exception {
        int i;
        ArrayList<Object> result = new ArrayList<Object>();
        for (i = 0; i < this.m_UnparametrizedScripts.length; ++i) {
            result.add(Groovy.getSingleton().newInstance((File)this.m_UnparametrizedScripts[i], Object.class));
        }
        for (i = 0; i < this.m_ParametrizedScripts.length; ++i) {
            result.add(this.m_ParametrizedScripts[i].loadPlugin(this.getFlowContext()));
        }
        return result.toArray(new Object[0]);
    }

    protected void configurePlugins(Object[] plugins) {
        for (int i = 0; i < plugins.length; ++i) {
            if (plugins[i] instanceof FlowContextHandler) {
                ((FlowContextHandler)plugins[i]).setFlowContext(this.getFlowContext());
            }
            if (!(plugins[i] instanceof LoggingLevelHandler)) continue;
            ((LoggingLevelHandler)plugins[i]).setLoggingLevel(this.getLoggingLevel());
        }
    }

    protected Server doStart() throws Exception {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        this.configureInterceptors(factory);
        Object[] plugins = this.loadPlugins();
        this.configurePlugins(plugins);
        factory.setServiceBeans(Arrays.asList(plugins));
        factory.setAddress(this.getURL());
        this.configureTLS(factory);
        return factory.create();
    }
}

