/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.core.scripting.Groovy;
import adams.core.scripting.GroovyScript;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractScriptActor;
import adams.flow.core.ActorUtils;

public abstract class AbstractGroovyActor
extends AbstractScriptActor {
    private static final long serialVersionUID = -5904986133981940404L;
    protected transient AbstractActor m_ActorObject;
    protected GroovyScript m_InlineScript;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("scriptFile");
        if (variable != null || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        variable = this.getOptionManager().getVariableForProperty("inlineScript");
        if (variable != null) {
            return variable;
        }
        return Utils.shorten((String)this.m_InlineScript.stringValue(), (int)50);
    }

    public String scriptOptionsTipText() {
        return "The options for the Groovy script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Groovy actor.";
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = Groovy.loadScriptObject(AbstractActor.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions);
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        String result = null;
        AbstractActor script = (AbstractActor)this.m_ScriptObject;
        if (ActorUtils.isStandalone((AbstractActor)this) && !ActorUtils.isStandalone((AbstractActor)script)) {
            result = "Script object is not a singleton!";
        } else if (ActorUtils.isSource((AbstractActor)this) && !ActorUtils.isSource((AbstractActor)script)) {
            result = "Script object is not a source!";
        } else if (ActorUtils.isTransformer((AbstractActor)this) && !ActorUtils.isTransformer((AbstractActor)script)) {
            result = "Script object is not a transformer!";
        } else if (ActorUtils.isSink((AbstractActor)this) && !ActorUtils.isSink((AbstractActor)script)) {
            result = "Script object is not a sink!";
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActorObject = (AbstractActor)this.m_ScriptObject;
            result = this.m_ActorObject.setUp();
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        if (this.m_ActorObject != null) {
            this.m_ActorObject.destroy();
        }
        this.m_ActorObject = null;
    }
}

