/*
 * Decompiled with CFR 0.152.
 */
package adams.core.scripting;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.scripting.GroovyScript;
import adams.env.Environment;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Groovy
implements Serializable {
    private static final long serialVersionUID = -2628766602043134673L;
    public static final String CLASS_GROOVYCLASSLOADER = "groovy.lang.GroovyClassLoader";
    protected static boolean m_Present = false;
    protected Object m_ClassLoader = Groovy.newClassLoader();

    public Object getClassLoader() {
        return this.m_ClassLoader;
    }

    public Object invoke(String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        if (this.getClassLoader() != null) {
            result = Groovy.invoke(this.getClassLoader(), methodName, paramClasses, paramValues);
        }
        return result;
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Object newClassLoader() {
        Object result = null;
        if (Groovy.isPresent()) {
            try {
                Class<?> cls = Class.forName(CLASS_GROOVYCLASSLOADER);
                Constructor<?> constr = cls.getConstructor(ClassLoader.class);
                result = constr.newInstance(Groovy.class.getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    public static Object newInstance(File file, Class template) {
        Object result = null;
        if (!Groovy.isPresent()) {
            return result;
        }
        Object interpreter = Groovy.newClassLoader();
        if (interpreter == null) {
            return result;
        }
        try {
            Class cls = (Class)Groovy.invoke(interpreter, "parseClass", new Class[]{File.class}, new Object[]{file.getAbsoluteFile()});
            result = cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object invoke(Object o, String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, paramClasses);
            result = m.invoke(o, paramValues);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Object[] loadScriptObject(Class cls, PlaceholderFile scriptFile, GroovyScript inlineScript, String scriptOptions) {
        Object[] result = new Object[2];
        PlaceholderFile file = null;
        if (scriptFile.isDirectory()) {
            if (inlineScript.getValue().trim().length() == 0) {
                result[0] = "Neither script file nor inline script provided!";
            } else {
                try {
                    file = new PlaceholderFile(File.createTempFile(Environment.getInstance().getProject() + "-", ".groovy"));
                    FileUtils.saveToFile((String[])inlineScript.getValue().split("\n"), (File)file);
                }
                catch (Exception e) {
                    result[0] = "Failed to save inline script to temporary file: " + Utils.throwableToString((Throwable)e);
                }
            }
        } else {
            file = scriptFile;
        }
        if (result[0] == null) {
            try {
                if (file.isFile()) {
                    result[1] = Groovy.newInstance((File)file, cls);
                    if (result[1] != null) {
                        if (!AdditionalOptionsHandlerUtils.setOptions((Object)result[1], (String)scriptOptions)) {
                            result[0] = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + file;
                        }
                    } else {
                        result[0] = "Failed to instantiate script '" + file + "'!";
                    }
                } else {
                    result[0] = "No script provided!";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result[0] = "Failed to initialize Groovy script '" + file + "': " + e.toString();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Groovy present: " + Groovy.isPresent());
        } else {
            Groovy groovy = new Groovy();
            if (groovy.getClassLoader() == null) {
                System.err.println("Cannot instantiate Groovy ClassLoader!");
            } else {
                Object groovyObject = Groovy.newInstance(new File(args[0]), Object.class);
                Groovy.invoke(groovyObject, "run", new Class[0], new Object[0]);
            }
        }
    }

    static {
        try {
            Class.forName(CLASS_GROOVYCLASSLOADER);
            m_Present = true;
        }
        catch (Exception e) {
            m_Present = false;
        }
    }
}

