/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.Conversion;
import adams.data.conversion.StringToInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.Convert;
import adams.flow.transformer.Groovy;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class GroovyTest
extends AbstractFlowTest {
    public GroovyTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("SimpleTransformer.groovy");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("SimpleTransformer.groovy");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("1"), new BaseString("3"), new BaseString("23"), new BaseString("423"), new BaseString("34")});
        StringToInt s2i = new StringToInt();
        Convert con = new Convert();
        con.setConversion((Conversion)s2i);
        Groovy gr = new Groovy();
        gr.setScriptOptions(new BaseText("add=10"));
        gr.setScriptFile((PlaceholderFile)new TmpFile("SimpleTransformer.groovy"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, con, gr, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(GroovyTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GroovyTest.runTest((Test)GroovyTest.suite());
    }
}

