/*
 * Decompiled with CFR 0.152.
 */
package adams.core.scripting;

import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.io.TempUtils;
import adams.core.logging.LoggingObject;
import adams.core.scripting.GroovyScript;
import adams.env.Environment;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class Groovy
extends LoggingObject {
    private static final long serialVersionUID = -2628766602043134673L;
    public static final String CLASS_GROOVYCLASSLOADER = "groovy.lang.GroovyClassLoader";
    protected boolean m_Present;
    protected Object m_ClassLoader;
    protected static Groovy m_Singleton;

    protected Groovy() {
        try {
            Class.forName(CLASS_GROOVYCLASSLOADER);
            this.m_Present = true;
        }
        catch (Exception e) {
            this.m_Present = false;
        }
        this.m_ClassLoader = this.newClassLoader();
    }

    public Object getClassLoader() {
        return this.m_ClassLoader;
    }

    public Object invoke(String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        if (this.getClassLoader() != null) {
            result = this.invoke(this.getClassLoader(), methodName, paramClasses, paramValues);
        }
        return result;
    }

    public boolean isPresent() {
        return this.m_Present;
    }

    public Object newClassLoader() {
        Object result = null;
        if (this.isPresent()) {
            try {
                Class<?> cls = Class.forName(CLASS_GROOVYCLASSLOADER);
                Constructor<?> constr = cls.getConstructor(ClassLoader.class);
                result = constr.newInstance(Groovy.class.getClassLoader());
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to instantiate new classloader!", (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public Object newInstance(File file, Class template) {
        Object result = null;
        if (!this.isPresent()) {
            return result;
        }
        Object interpreter = this.newClassLoader();
        if (interpreter == null) {
            return result;
        }
        try {
            Class cls = (Class)this.invoke(interpreter, "parseClass", new Class[]{File.class}, new Object[]{file.getAbsoluteFile()});
            result = cls.newInstance();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to instantiate script from '" + file + "' as '" + template.getName() + "'!", (Throwable)e);
        }
        return result;
    }

    public Object invoke(Object o, String methodName, Class[] paramClasses, Object[] paramValues) {
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, paramClasses);
            result = m.invoke(o, paramValues);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to invoke method '" + methodName + "' (" + Utils.arrayToString((Object)paramClasses) + " with " + Utils.arrayToString((Object)paramValues) + ")!", (Throwable)e);
            result = null;
        }
        return result;
    }

    public Object[] loadScriptObject(Class cls, PlaceholderFile scriptFile, GroovyScript inlineScript, String scriptOptions, Variables vars) {
        Object[] result = new Object[2];
        PlaceholderFile file = null;
        if (scriptFile.isDirectory()) {
            if (inlineScript.getValue().trim().length() == 0) {
                result[0] = "Neither script file nor inline script provided!";
            } else {
                try {
                    file = new PlaceholderFile(TempUtils.createTempFile((String)(Environment.getInstance().getProject() + "-"), (String)".groovy"));
                    FileUtils.saveToFile((String[])inlineScript.getValue().split("\n"), (File)file);
                }
                catch (Exception e) {
                    result[0] = "Failed to save inline script to temporary file: " + Utils.throwableToString((Throwable)e);
                    this.getLogger().log(Level.SEVERE, "Failed to save inline script to temporary file!", (Throwable)e);
                }
            }
        } else {
            file = scriptFile;
        }
        if (result[0] == null) {
            try {
                if (file.isFile()) {
                    result[1] = this.newInstance((File)file, cls);
                    if (result[1] != null) {
                        if (!AdditionalOptionsHandlerUtils.setOptions((Object)result[1], (String)scriptOptions, (Variables)vars)) {
                            result[0] = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + file;
                        }
                    } else {
                        result[0] = "Failed to instantiate script '" + file + "'!";
                    }
                } else {
                    result[0] = "No script provided!";
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to initialize Groovy script '" + file + "'!", (Throwable)e);
                result[0] = "Failed to initialize Groovy script '" + file + "': " + e.toString();
            }
        }
        return result;
    }

    public static synchronized Groovy getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Groovy();
        }
        return m_Singleton;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        if (args.length == 0) {
            System.out.println("Groovy present: " + Groovy.getSingleton().isPresent());
        } else if (Groovy.getSingleton().getClassLoader() == null) {
            System.err.println("Cannot instantiate Groovy ClassLoader!");
        } else {
            Object groovyObject = Groovy.getSingleton().newInstance(new File(args[0]), Object.class);
            if (groovyObject == null) {
                System.err.println("Failed to instantiate script: " + args[0]);
            } else {
                System.out.println("Successfully instantiated script: " + args[0]);
            }
        }
    }
}

