/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.scripting.GroovyScript;
import adams.flow.core.Actor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.AbstractScriptedTemplate;

public class Groovy
extends AbstractScriptedTemplate {
    private static final long serialVersionUID = 3861631532032659677L;
    protected GroovyScript m_InlineScript;

    public String globalInfo() {
        return "Uses a Groovy script to generate a sub-flow.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        return QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)this.m_InlineScript.stringValue(), (int)50));
    }

    public String scriptOptionsTipText() {
        return "The options for the Groovy script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Groovy actor.";
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Groovy.getSingleton().loadScriptObject(AbstractActorTemplate.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    protected Actor executeScript() {
        return ((AbstractActorTemplate)this.m_ScriptObject).generate();
    }

    public boolean isInteractive() {
        return this.m_ScriptObject != null && ((AbstractActorTemplate)this.m_ScriptObject).isInteractive();
    }
}

