/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.scripting.GroovyScript;
import adams.data.container.DataContainer;
import adams.data.report.AbstractReportFilter;
import adams.data.report.AbstractScriptedReportFilter;

public class Groovy
extends AbstractScriptedReportFilter {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractReportFilter m_FilterObject;
    protected GroovyScript m_InlineScript;

    public String globalInfo() {
        return "A report filter that uses a Groovy script for processing the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String scriptOptionsTipText() {
        return "The options for the Groovy script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Groovy actor.";
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Groovy.getSingleton().loadScriptObject(AbstractReportFilter.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    protected void checkData(DataContainer data) {
        super.checkData(data);
        this.m_FilterObject = (AbstractReportFilter)this.m_ScriptObject;
    }

    protected DataContainer processData(DataContainer data) {
        return this.m_FilterObject.filter(data);
    }

    public void destroy() {
        super.destroy();
        this.m_FilterObject = null;
    }
}

