/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.scripting.GroovyScript;
import adams.flow.condition.bool.AbstractScriptedCondition;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public class Groovy
extends AbstractScriptedCondition {
    private static final long serialVersionUID = 4394482470846849594L;
    protected transient BooleanCondition m_ConditionObject;
    protected GroovyScript m_InlineScript;

    public String globalInfo() {
        return "A boolean condition that uses the condition defined in a Groovy script.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        return QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)this.m_InlineScript.stringValue(), (int)50));
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Groovy.getSingleton().loadScriptObject(BooleanCondition.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        this.m_ConditionObject = (BooleanCondition)this.m_ScriptObject;
        return null;
    }

    protected boolean doScriptEvaluate(Actor owner, Token token) {
        return this.m_ConditionObject.evaluate(owner, token);
    }
}

