/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.Variables;
import adams.core.option.OptionHandler;
import adams.core.scripting.Groovy;
import adams.core.scripting.GroovyScript;
import adams.flow.core.AbstractScriptedActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.AdditionalOptionsHandlerUtils;

public abstract class AbstractGroovyActor
extends AbstractScriptedActor {
    private static final long serialVersionUID = -5904986133981940404L;
    protected transient Actor m_ActorObject;
    protected GroovyScript m_InlineScript;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    protected void reset() {
        super.reset();
        this.m_ActorObject = null;
    }

    public String getQuickInfo() {
        Object result;
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory()) {
            result = super.getQuickInfo();
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)this.m_InlineScript.stringValue(), (int)50));
            if (result != null) {
                result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"scriptOptions", (Object)this.m_ScriptOptions, (String)", options: ");
            }
        }
        return result;
    }

    public String scriptOptionsTipText() {
        return "The options for the Groovy script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Groovy actor.";
    }

    protected GroovyScript getDefaultInlineScript() {
        return new GroovyScript();
    }

    public void setInlineScript(GroovyScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public GroovyScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = Groovy.getSingleton().loadScriptObject(Actor.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        String result = null;
        Actor script = (Actor)this.m_ScriptObject;
        if (ActorUtils.isStandalone((Actor)this) && !ActorUtils.isStandalone((Actor)script)) {
            result = "Script object is not a singleton!";
        } else if (ActorUtils.isSource((Actor)this) && !ActorUtils.isSource((Actor)script)) {
            result = "Script object is not a source!";
        } else if (ActorUtils.isTransformer((Actor)this) && !ActorUtils.isTransformer((Actor)script)) {
            result = "Script object is not a transformer!";
        } else if (ActorUtils.isSink((Actor)this) && !ActorUtils.isSink((Actor)script)) {
            result = "Script object is not a sink!";
        }
        return result;
    }

    public String preExecute() {
        String result = super.preExecute();
        if (result == null && this.m_ActorObject == null) {
            this.m_ActorObject = (Actor)this.m_ScriptObject;
            result = this.m_ActorObject.setUp();
        }
        return result;
    }

    protected String updateScriptOptions() {
        if (this.getScriptOptions().getValue().length() == 0) {
            return null;
        }
        try {
            AdditionalOptionsHandlerUtils.setOptions((Object)this.m_ActorObject, (String)this.getScriptOptions().getValue(), (Variables)this.getVariables());
            return null;
        }
        catch (Exception e) {
            return this.handleException("Failed to update options", e);
        }
    }

    public void wrapUp() {
        super.wrapUp();
        if (this.m_ActorObject != null) {
            this.m_ActorObject.destroy();
        }
        this.m_ActorObject = null;
    }
}

