/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.data.heatmap.Heatmap;
import adams.data.instances.AbstractFieldInstanceGenerator;
import adams.data.instances.HeatmapArffUtils;
import adams.data.report.Field;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class RawInstanceGenerator
extends AbstractFieldInstanceGenerator {
    private static final long serialVersionUID = -5861208629400569487L;

    public String globalInfo() {
        return "A generator for turning a heatmap and fields of its report into weka.core.Instance objects.\nThe intensities are output row-wise.";
    }

    @Override
    protected void checkHeader(Heatmap data) {
        int size = this.m_OutputHeader.numAttributes();
        if (this.m_AddDatabaseID) {
            --size;
        }
        if (size != this.m_Fields.length + data.size()) {
            throw new IllegalStateException("Number of fields+intensities and output attributes differ (" + data + "): " + this.m_Fields.length + "+" + data.size() + " != " + size);
        }
    }

    protected void generateHeader(Heatmap data) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < data.getHeight(); ++i) {
            for (int n = 0; n < data.getWidth(); ++n) {
                atts.add(new Attribute(HeatmapArffUtils.getIntensityName(i, n)));
            }
        }
        StringBuilder name = new StringBuilder();
        for (Field target : this.m_Fields) {
            atts.add(this.createAttribute(target, name));
        }
        this.m_OutputHeader = new Instances(((Object)((Object)this)).getClass().getName() + "-" + name.toString(), atts, 0);
    }

    protected Instance generateOutput(Heatmap data) {
        double[] values = new double[this.m_OutputHeader.numAttributes()];
        int offset = 0;
        if (this.m_AddDatabaseID) {
            ++offset;
        }
        for (int i = 0; i < data.getHeight(); ++i) {
            for (int n = 0; n < data.getWidth(); ++n) {
                values[offset + i * data.getWidth() + n] = data.get(i, n);
            }
        }
        this.addFields(data, values);
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_OutputHeader);
        return result;
    }
}

