/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.data.heatmap.Heatmap;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.util.List;

public abstract class AbstractHeatmapWriter
extends AbstractDataContainerWriter<Heatmap> {
    private static final long serialVersionUID = 2897884035699563232L;

    public boolean canWriteMultiple() {
        return false;
    }

    protected void checkData(List<Heatmap> data) {
        super.checkData(data);
        for (Heatmap map : data) {
            Report meta = map.getReport().getClone();
            if (!meta.hasValue("Height")) {
                meta.setValue((AbstractField)new Field("Height", DataType.NUMERIC), (Object)map.getHeight());
            }
            if (!meta.hasValue("Width")) {
                meta.setValue((AbstractField)new Field("Width", DataType.NUMERIC), (Object)map.getWidth());
            }
            map.setReport(meta);
        }
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractHeatmapWriter.class);
    }
}

