/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.option.OptionUtils;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.boofcv.transformer.PassThrough;
import adams.data.image.AbstractImageContainer;
import adams.gui.visualization.heatmap.plugins.AbstractApplyImageTransformer;
import java.awt.image.BufferedImage;

public class BoofCVTransformer
extends AbstractApplyImageTransformer {
    private static final long serialVersionUID = 8515360604357492725L;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "BoofCV transformer...";
    }

    public String getIconName() {
        return "boofcv.png";
    }

    @Override
    protected Class getEditorType() {
        return AbstractBoofCVTransformer.class;
    }

    @Override
    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected BufferedImage process(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        AbstractBoofCVTransformer transformer = (AbstractBoofCVTransformer)this.m_Editor.getValue();
        BoofCVImageContainer input = new BoofCVImageContainer();
        input.setImage((Object)BoofCVHelper.toBoofCVImage((BufferedImage)image));
        BoofCVImageContainer[] transformed = (BoofCVImageContainer[])transformer.transform((AbstractImageContainer)input);
        if (transformed.length == 0) {
            this.getLogger().severe("No filtered image generated!");
        }
        if (transformed.length > 1) {
            this.getLogger().warning("Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = transformed[0].toBufferedImage();
        }
        return result;
    }
}

