/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.PlaceholderFile;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.SpreadSheetHeatmapReader;
import adams.data.io.output.AbstractHeatmapWriter;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;

public abstract class AbstractHeatmapWriterTestCase
extends AdamsTestCase {
    public AbstractHeatmapWriterTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/io/output/data");
    }

    protected List<Heatmap> load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        SpreadSheetHeatmapReader reader = new SpreadSheetHeatmapReader();
        reader.setUseAbsoluteSource(false);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected boolean save(List<Heatmap> data, String filename, AbstractHeatmapWriter writer) {
        writer.setOutput((PlaceholderFile)new TmpFile(filename));
        return writer.write(data);
    }

    protected abstract String[] getInputFiles();

    protected abstract String[] getOutputFiles();

    protected abstract AbstractHeatmapWriter[] getSetups();

    public void testSetups() {
        int i;
        String[] input = this.getInputFiles();
        String[] output = this.getOutputFiles();
        AbstractHeatmapWriter[] setups = this.getSetups();
        AbstractHeatmapWriterTestCase.assertEquals((String)"Number of input and output files differ!", (int)input.length, (int)output.length);
        AbstractHeatmapWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            List<Heatmap> data = this.load(input[i]);
            AbstractHeatmapWriterTestCase.assertNotNull((String)"Failed to load data?", data);
            boolean ok = this.save(data, output[i], setups[i]);
            AbstractHeatmapWriterTestCase.assertTrue((String)"Failed to save data?", (boolean)ok);
        }
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }

    protected boolean hasRegressionTest() {
        return false;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        if (!this.hasRegressionTest()) {
            return;
        }
        String[] input = this.getInputFiles();
        String[] output = this.getOutputFiles();
        AbstractHeatmapWriter[] setups = this.getSetups();
        AbstractHeatmapWriterTestCase.assertEquals((String)"Number of input and output files differ!", (int)input.length, (int)output.length);
        AbstractHeatmapWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            List<Heatmap> data = this.load(input[i]);
            AbstractHeatmapWriterTestCase.assertNotNull((String)"Failed to load data?", data);
            boolean ok = this.save(data, output[i], setups[i]);
            AbstractHeatmapWriterTestCase.assertTrue((String)"Failed to save data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, this.getRegressionIgnoredLineIndices());
        AbstractHeatmapWriterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

