/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter.heatmapthreshold;

import adams.data.conversion.HeatmapToBufferedImage;
import adams.data.conversion.HeatmapToBufferedImageConversion;
import adams.data.filter.heatmapthreshold.AbstractHeatmapThreshold;
import adams.data.heatmap.Heatmap;
import adams.data.image.BufferedImageContainer;
import java.awt.image.BufferedImage;

public abstract class AbstractBufferedImageBasedHeatmapThreshold
extends AbstractHeatmapThreshold {
    private static final long serialVersionUID = -1205777458822555932L;
    protected HeatmapToBufferedImageConversion m_Conversion;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "conversion", (Object)new HeatmapToBufferedImage());
    }

    public void setConversion(HeatmapToBufferedImageConversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public HeatmapToBufferedImageConversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to use for turning the heatmap into a BufferedImage.";
    }

    protected abstract double doCalcThreshold(Heatmap var1, BufferedImage var2);

    @Override
    protected double doCalcThreshold(Heatmap map) {
        this.m_Conversion.setInput(map);
        String msg = this.m_Conversion.convert();
        if (msg != null) {
            throw new IllegalStateException("Failed to convert Heatmap into BufferedImage: " + msg);
        }
        BufferedImage img = (BufferedImage)((BufferedImageContainer)this.m_Conversion.getOutput()).getImage();
        this.m_Conversion.cleanUp();
        return this.doCalcThreshold(map, img);
    }
}

