/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.conversion.HeatmapToBufferedImage;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.SimpleImageHeatmapReader;
import adams.data.io.output.AbstractHeatmapWriter;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import java.util.List;
import java.util.logging.Level;

public class SimpleImageHeatmapWriter
extends AbstractHeatmapWriter {
    private static final long serialVersionUID = -7828811375813385465L;
    protected HeatmapToBufferedImage m_Conversion;
    protected AbstractImageWriter m_Writer;

    public String globalInfo() {
        return "Turns the heatmap into an image and uses the specified image writer for saving it to a file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "conversion", (Object)new HeatmapToBufferedImage());
        this.m_OptionManager.add("writer", "writer", (Object)new JAIImageWriter());
    }

    protected void initialize() {
        super.initialize();
        this.m_OutputIsFile = true;
    }

    public String getFormatDescription() {
        return new SimpleImageHeatmapReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleImageHeatmapReader().getFormatExtensions();
    }

    public void setConversion(HeatmapToBufferedImage value) {
        this.m_Conversion = value;
        this.reset();
    }

    public HeatmapToBufferedImage getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion for turning the heatmap into an image before writing it to a file.";
    }

    public void setWriter(AbstractImageWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractImageWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The image writer to use.";
    }

    protected boolean writeData(List<Heatmap> data) {
        boolean result = false;
        try {
            this.m_Conversion.setInput(data.get(0));
            String msg = this.m_Conversion.convert();
            if (msg == null) {
                AbstractImageContainer cont = (AbstractImageContainer)this.m_Conversion.getOutput();
                msg = this.m_Writer.write(this.m_Output, cont);
                boolean bl = result = msg == null;
            }
            if (msg != null) {
                this.getLogger().severe("Failed to write heatmap to '" + this.m_Output + "': " + msg);
            }
            this.m_Conversion.cleanUp();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write heatmap to '" + this.m_Output + "':", e);
        }
        return result;
    }
}

