/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.overlay;

import adams.gui.visualization.heatmap.overlay.AbstractPositionableHeatmapOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AbstractPositionableHeatmapOverlayWithDimensions
extends AbstractPositionableHeatmapOverlay {
    private static final long serialVersionUID = 5439828929470172755L;
    protected int m_Width;
    protected int m_Height;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)-1, null);
    }

    protected abstract int getDefaultWidth();

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    public abstract String widthTipText();

    protected abstract int getDefaultHeight();

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    public abstract String heightTipText();

    @Override
    protected abstract void doPaintOverlay(ImagePanel.PaintPanel var1, Graphics var2, int var3, int var4);

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        int actX = this.m_X;
        int actY = this.m_Y;
        Rectangle bounds = panel.getBounds();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("bounds: " + bounds);
        }
        actX = this.m_X == -1 ? 0 : (this.m_X == -2 ? (bounds.width - this.m_Width) / 2 - 1 : (this.m_X == -3 ? bounds.width - this.m_Width - 1 : this.m_X));
        actY = this.m_Y == -1 ? 0 : (this.m_Y == -2 ? (bounds.height - this.m_Height) / 2 - 1 : (this.m_Y == -3 ? bounds.height - this.m_Height - 1 : this.m_Y));
        actY += this.m_Height;
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("x: " + this.m_X + " -> " + actX + ", y: " + this.m_Y + " -> " + actY);
        }
        this.doPaintOverlay(panel, g, actX, actY);
    }
}

