/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.HeatmapViewerPanel;
import adams.gui.visualization.heatmap.plugins.AbstractHeatmapViewerPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractSelectedHeatmapsViewerPlugin
extends AbstractHeatmapViewerPlugin {
    private static final long serialVersionUID = 869121794905442017L;
    protected HeatmapPanel[] m_SelectedPanels;

    public boolean canExecute(HeatmapPanel panel) {
        return panel != null && panel.getHeatmap() != null;
    }

    protected HeatmapPanel[] getAllPanels() {
        ArrayList<HeatmapPanel> result = new ArrayList<HeatmapPanel>();
        HeatmapViewerPanel owner = (HeatmapViewerPanel)((Object)GUIHelper.getParent((Container)this.m_CurrentPanel, HeatmapViewerPanel.class));
        if (owner != null) {
            result.addAll(Arrays.asList(owner.getAllPanels()));
        }
        return result.toArray(new HeatmapPanel[result.size()]);
    }

    protected JPanel createListPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        final HeatmapPanel[] panels = this.getAllPanels();
        DefaultListModel<String> model = new DefaultListModel<String>();
        int index = -1;
        for (HeatmapPanel p : panels) {
            if (p == this.m_CurrentPanel) {
                index = model.getSize();
            }
            model.addElement(model.getSize() + 1 + ": " + p.getTitle());
        }
        final JList list = new JList(model);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indices = list.getSelectedIndices();
                AbstractSelectedHeatmapsViewerPlugin.this.m_SelectedPanels = new HeatmapPanel[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    AbstractSelectedHeatmapsViewerPlugin.this.m_SelectedPanels[i] = panels[indices[i]];
                }
            }
        });
        list.setSelectedIndex(index);
        BaseScrollPane scrollPane = new BaseScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 1));
        result.add((Component)scrollPane, "Center");
        return result;
    }

    protected abstract JPanel createConfigurationPanel(ApprovalDialog var1);

    protected Dimension getDialogSize() {
        return new Dimension(600, 400);
    }

    protected boolean hasApprovalButton() {
        return true;
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected ApprovalDialog createDialog() {
        ApprovalDialog result = ((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog() != null ? new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentFrame(), true);
        result.setTitle(this.getCaption());
        result.setApproveVisible(this.hasApprovalButton());
        result.setCancelVisible(this.hasCancelButton());
        result.setDiscardVisible(false);
        result.setSize(this.getDialogSize());
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Please select:"));
        result.getContentPane().add((Component)panel, "North");
        panel = new JPanel(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        JPanel panelList = this.createListPanel(result);
        panelList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelConfig = this.createConfigurationPanel(result);
        if (panelConfig == null) {
            panel.add((Component)panelList, "Center");
        } else {
            panel.add((Component)panelList, "West");
            panel.add((Component)panelConfig, "Center");
        }
        return result;
    }

    protected String processInit() {
        return null;
    }

    protected abstract String process(HeatmapPanel var1);

    protected String processFinish() {
        return null;
    }

    protected String process() {
        String result = this.processInit();
        if (result == null) {
            HeatmapPanel panel;
            HeatmapPanel[] heatmapPanelArray = this.m_SelectedPanels;
            int n = heatmapPanelArray.length;
            for (int i = 0; i < n && (result = this.process(panel = heatmapPanelArray[i])) == null; ++i) {
            }
        }
        if (result == null) {
            result = this.processFinish();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        ApprovalDialog dialog = this.createDialog();
        if (dialog == null) {
            result = "Failed to create dialog!";
        } else {
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.getOption() == 0) {
                result = this.process();
            } else if (dialog.getOption() == 2) {
                this.m_CanceledByUser = true;
            }
        }
        return result;
    }
}

