/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetToHeatmap
extends AbstractConversion {
    private static final long serialVersionUID = 4705676366087704263L;
    protected double m_MissingValue;

    public String globalInfo() {
        return "Turns an all-numeric spreadsheet into a heatmap.\nMissing values/cells are tolerated and replaced with the specified value for missing values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("missing-value", "missingValue", (Object)0.0);
    }

    public void setMissingValue(double value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public double getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to use in case of missing values/cells.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Heatmap.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        HeaderRow header = sheet.getHeaderRow();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (sheet.isNumeric(i)) continue;
            throw new IllegalArgumentException("Column #" + (i + 1) + " (" + header.getCell(i).getContent() + ") is not numeric!");
        }
        Heatmap result = new Heatmap(sheet.getRowCount(), sheet.getColumnCount());
        for (int n = 0; n < sheet.getRowCount(); ++n) {
            DataRow row = sheet.getRow(n);
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                String key = header.getCellKey(i);
                double value = this.m_MissingValue;
                if (row.hasCell(key) && !row.getCell(key).isMissing()) {
                    value = row.getCell(key).toDouble();
                }
                result.set(n, i, value);
            }
        }
        return result;
    }
}

