/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter.heatmapcrop;

import adams.data.filter.heatmapcrop.AbstractHeatmapCrop;
import adams.data.heatmap.Heatmap;

public class Submap
extends AbstractHeatmapCrop {
    private static final long serialVersionUID = 8109859053628417241L;
    protected int m_Row;
    protected int m_Column;
    protected int m_Height;
    protected int m_Width;

    public String globalInfo() {
        return "Creates the submap using the specified row and column (both 0-based), width and height.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)0, (Number)0, null);
        this.m_OptionManager.add("col", "column", (Object)0, (Number)0, null);
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
    }

    public void setRow(int value) {
        if (this.getOptionManager().isValid("row", (Number)value)) {
            this.m_Row = value;
            this.reset();
        }
    }

    public int getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the top-left corner, the starting point of the submap (0-based).";
    }

    public void setColumn(int value) {
        if (this.getOptionManager().isValid("column", (Number)value)) {
            this.m_Column = value;
            this.reset();
        }
    }

    public int getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the top-left corner, the starting point of the submap (0-based).";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the submap.";
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the submap.";
    }

    @Override
    protected Heatmap doCrop(Heatmap map) {
        return map.submap(this.m_Row, this.m_Column, this.m_Height, this.m_Width);
    }
}

