/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmapfeatures;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.heatmap.Heatmap;
import adams.data.heatmap.HeatmapValue;
import adams.data.heatmapfeatures.AbstractHeatmapFeatureGenerator;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;

public class Max
extends AbstractHeatmapFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected boolean m_OutputPosition;

    public String globalInfo() {
        return "Extracts the highest value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-position", "outputPosition", (Object)false);
    }

    public void setOutputPosition(boolean value) {
        this.m_OutputPosition = value;
        this.reset();
    }

    public boolean getOutputPosition() {
        return this.m_OutputPosition;
    }

    public String outputPositionTipText() {
        return "If enabled, the position of the maximum gets output as well (x/y; 0-based).";
    }

    @Override
    public HeaderDefinition createHeader(Heatmap map) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("max", DataType.NUMERIC);
        if (this.m_OutputPosition) {
            result.add("x", DataType.NUMERIC);
            result.add("y", DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(Heatmap map) {
        List[] result = new List[]{new ArrayList()};
        HeatmapValue max = map.getMaxValue();
        result[0].add(max.getValue());
        if (this.m_OutputPosition) {
            result[0].add(max.getX());
            result[0].add(max.getY());
        }
        return result;
    }
}

