/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.Notes;
import adams.data.conversion.HeatmapToBufferedImage;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.PassThrough;
import java.awt.image.BufferedImage;

public class HeatmapLocateObjects
extends AbstractArrayProvider {
    private static final long serialVersionUID = 2180810317840558011L;
    public static final String BACKUP_QUEUE = "queue";
    public static final String FIELD_X = "X";
    public static final String FIELD_Y = "Y";
    public static final String FIELD_WIDTH = "Width";
    public static final String FIELD_HEIGHT = "Height";
    protected HeatmapToBufferedImage m_Conversion;
    protected AbstractObjectLocator m_Locator;
    protected boolean m_GenerateReport;
    protected String m_Prefix;

    public String globalInfo() {
        return "Locates objects in a heatmap and forwards a sub-heatmap per located object, cropped around the object.\nIt is also possible to simply annotate the heatmap by storing the locations of the located objects in the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("conversion", "conversion", (Object)new HeatmapToBufferedImage());
        this.m_OptionManager.add("locator", "locator", (Object)new PassThrough());
        this.m_OptionManager.add("generate-report", "generateReport", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
    }

    public String outputArrayTipText() {
        return "Outputs the heatmaps either one by one or as array.";
    }

    public void setConversion(HeatmapToBufferedImage value) {
        this.m_Conversion = value;
        this.reset();
    }

    public HeatmapToBufferedImage getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion for turning the heatmap into an image before applying the locator algorithm.";
    }

    public void setLocator(AbstractObjectLocator value) {
        this.m_Locator = value;
        this.reset();
    }

    public AbstractObjectLocator getLocator() {
        return this.m_Locator;
    }

    public String locatorTipText() {
        return "The algorithm for locating the objects.";
    }

    public void setGenerateReport(boolean value) {
        this.m_GenerateReport = value;
        this.reset();
    }

    public boolean getGenerateReport() {
        return this.m_GenerateReport;
    }

    public String generateReportTipText() {
        return "If enabled, an annotated heatmap containing a report with all the locations is generated instead of separate heatmap objects.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix to use when generating a report.";
    }

    public String getQuickInfo() {
        String result = "locator: ";
        String variable = this.getOptionManager().getVariableForProperty("locator");
        result = variable != null ? result + variable : result + this.m_Locator.getClass().getSimpleName();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    protected Class getItemClass() {
        return Heatmap.class;
    }

    protected String doExecute() {
        String result = null;
        BufferedImage image = null;
        Heatmap heatmap = (Heatmap)this.m_InputToken.getPayload();
        Notes notes = heatmap.getNotes().getClone();
        Report report = heatmap.getReport().getClone();
        this.m_Conversion.setInput(heatmap);
        result = this.m_Conversion.convert();
        if (result == null) {
            AbstractImageContainer cont = (AbstractImageContainer)this.m_Conversion.getOutput();
            image = cont.toBufferedImage();
        }
        if (this.isHeadless()) {
            this.m_OutputToken = new Token((Object)heatmap);
            return result;
        }
        try {
            LocatedObjects objects = this.m_GenerateReport ? this.m_Locator.annotate(image) : this.m_Locator.locate(image);
            if (this.m_Locator.hasErrors()) {
                if (notes == null) {
                    notes = new Notes();
                }
                for (String error : this.m_Locator.getErrors()) {
                    notes.addError(((Object)((Object)this)).getClass(), error);
                }
            }
            if (this.m_Locator.hasWarnings()) {
                if (notes == null) {
                    notes = new Notes();
                }
                for (String warning : this.m_Locator.getWarnings()) {
                    notes.addWarning(((Object)((Object)this)).getClass(), warning);
                }
            }
            this.m_Queue.clear();
            if (this.m_GenerateReport) {
                heatmap = heatmap.getClone();
                heatmap.getReport().mergeWith(objects.toReport(this.m_Prefix));
                this.m_Queue.add(heatmap);
            } else {
                for (LocatedObject object : objects) {
                    Heatmap submap = heatmap.submap(object.getY(), object.getX(), object.getHeight(), object.getWidth());
                    submap.getNotes().mergeWith(notes);
                    Report reportNew = new Report();
                    reportNew.setNumericValue(FIELD_X, (double)object.getX());
                    reportNew.setNumericValue(FIELD_Y, (double)object.getY());
                    reportNew.setNumericValue(FIELD_WIDTH, (double)object.getWidth());
                    reportNew.setNumericValue(FIELD_HEIGHT, (double)object.getHeight());
                    submap.setReport(reportNew);
                    submap.getReport().mergeWith(report);
                    this.m_Queue.add(submap);
                }
            }
            this.m_Locator.cleanUp();
        }
        catch (Exception e) {
            result = this.handleException("Failed to locate objects!", e);
        }
        return result;
    }

    public void stopExecution() {
        this.m_Locator.stopExecution();
        super.stopExecution();
    }
}

