/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImage;
import adams.data.jai.BufferedImageContainer;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class HeatmapToBufferedImage
extends AbstractConversion {
    private static final long serialVersionUID = 2535421741524997185L;
    protected AbstractColorGradientGenerator m_Generator;
    protected Color[] m_GradientColors;

    public String globalInfo() {
        return "Turns a heatmap into a BufferedImage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BiColorGenerator());
    }

    protected void reset() {
        super.reset();
        this.m_GradientColors = null;
    }

    public void setGenerator(AbstractColorGradientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for creating the gradient colors.";
    }

    public Class accepts() {
        return Heatmap.class;
    }

    public Class generates() {
        return AbstractImage.class;
    }

    protected Color[] getGradientColors() {
        if (this.m_GradientColors == null) {
            this.m_GradientColors = this.m_Generator.generate();
        }
        return this.m_GradientColors;
    }

    protected Object doConvert() throws Exception {
        int x;
        int y;
        Heatmap map = (Heatmap)this.m_Input;
        Color[] colors = this.getGradientColors();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (y = 0; y < map.getHeight(); ++y) {
            for (x = 0; x < map.getWidth(); ++x) {
                if (map.get(y, x) > 0.0) {
                    min = Math.min(map.get(y, x), min);
                }
                max = Math.max(map.get(y, x), max);
            }
        }
        double range = max - min;
        BufferedImage image = new BufferedImage(map.getWidth(), map.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        for (y = 0; y < map.getHeight(); ++y) {
            for (x = 0; x < map.getWidth(); ++x) {
                Color color = map.get(y, x) == 0.0 ? colors[0] : colors[(int)((map.get(y, x) - min) / range * (double)(colors.length - 2)) + 1];
                g.setColor(color);
                g.drawLine(x, y, x, y);
            }
        }
        BufferedImageContainer result = new BufferedImageContainer();
        result.setImage((Object)image);
        return result;
    }
}

