/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.heatmap.Heatmap;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.heatmap.HeatmapPanel;
import java.awt.BorderLayout;
import java.awt.Component;

public class HeatmapDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -5963541661512220421L;
    protected AbstractColorGradientGenerator m_ColorGenerator;

    public String globalInfo() {
        return "Actor that displays heatmaps.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-generator", "colorGenerator", (Object)new BiColorGenerator());
    }

    protected int getDefaultWidth() {
        return 1000;
    }

    protected int getDefaultHeight() {
        return 700;
    }

    public void setColorGenerator(AbstractColorGradientGenerator value) {
        this.m_ColorGenerator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getColorGenerator() {
        return this.m_ColorGenerator;
    }

    public String colorGeneratorTipText() {
        return "The generator for the color gradient.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        String variable = this.getOptionManager().getVariableForProperty("colorGenerator");
        result = ", generator: ";
        result = variable != null ? result + variable : result + this.m_ColorGenerator.getClass().getSimpleName();
        return result;
    }

    public void clearPanel() {
        ((HeatmapPanel)this.m_Panel).setHeatmap(null);
    }

    protected BasePanel newPanel() {
        HeatmapPanel result = new HeatmapPanel(null);
        result.setColorGenerator(this.m_ColorGenerator);
        return result;
    }

    protected String createTitle() {
        if (this.m_ShortTitle) {
            return "Heatmap - " + this.getName();
        }
        return "Heatmap - " + this.getFullName();
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    protected void display(Token token) {
        ((HeatmapPanel)this.m_Panel).setHeatmap((Heatmap)token.getPayload());
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractDisplayPanel result = new AbstractDisplayPanel("Heatmap"){
            private static final long serialVersionUID = -9139363702312636367L;
            protected HeatmapPanel m_HeatmapPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_HeatmapPanel = new HeatmapPanel(null);
                this.m_HeatmapPanel.setColorGenerator(HeatmapDisplay.this.m_ColorGenerator);
                this.add((Component)((Object)this.m_HeatmapPanel), "Center");
            }

            public void display(Token token) {
                this.m_HeatmapPanel.setHeatmap((Heatmap)token.getPayload());
            }

            public void cleanUp() {
            }

            public void clearPanel() {
            }
        };
        result.display(token);
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

