/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.io.input.FloatMatrixHeatmapReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.AbstractHeatmapWriter;
import adams.data.io.output.FloatMatrixHeatmapWriter;
import adams.gui.chooser.AbstractDataContainerFileChooser;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.io.File;
import java.util.Vector;

public class HeatmapFileChooser
extends AbstractDataContainerFileChooser<Heatmap> {
    private static final long serialVersionUID = -5373058011025481738L;

    public HeatmapFileChooser() {
    }

    public HeatmapFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public HeatmapFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractDataContainerReader<Heatmap> getDefaultReader() {
        return new FloatMatrixHeatmapReader();
    }

    protected AbstractDataContainerWriter<Heatmap> getDefaultWriter() {
        return new FloatMatrixHeatmapWriter();
    }

    protected void doInitializeFilters() {
        HeatmapFileChooser.initFilters((AbstractDataContainerFileChooser)this, (boolean)true, (String[])AbstractHeatmapReader.getReaders());
        HeatmapFileChooser.initFilters((AbstractDataContainerFileChooser)this, (boolean)false, (String[])AbstractHeatmapWriter.getWriters());
    }

    public AbstractDataContainerReader<Heatmap> getReaderForFile(File file) {
        AbstractDataContainerReader result = null;
        for (Vector list : m_ReaderFileFilters.values()) {
            for (AbstractDataContainerFileChooser.DataContainerFileExtensionFilter filter : list) {
                if (!filter.accept(VFSUtils.toFileObject((File)file))) continue;
                try {
                    result = (AbstractDataContainerReader)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate reader '" + filter.getClassname() + "':");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public AbstractDataContainerWriter<Heatmap> getWriterForFile(File file) {
        AbstractDataContainerWriter result = null;
        for (Vector list : m_WriterFileFilters.values()) {
            for (AbstractDataContainerFileChooser.DataContainerFileExtensionFilter filter : list) {
                if (!filter.accept(VFSUtils.toFileObject((File)file))) continue;
                try {
                    result = (AbstractDataContainerWriter)Class.forName(filter.getClassname()).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate writer '" + filter.getClassname() + "':");
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

