/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.Collections;
import java.util.Vector;

public class HeatmapToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 4500736133110802963L;

    public String globalInfo() {
        return "Turns a heatmap into a spreadsheet object.\nThe attached report gets stored as comments.";
    }

    public Class accepts() {
        return Heatmap.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int x;
        SpreadSheet result = new SpreadSheet();
        Heatmap map = (Heatmap)this.m_Input;
        Vector fields = map.getReport().getFields();
        Collections.sort(fields);
        for (AbstractField field : fields) {
            result.addComment(field.getName() + ": " + map.getReport().getValue(field));
        }
        HeaderRow row = result.getHeaderRow();
        for (x = 0; x < map.getWidth(); ++x) {
            row.addCell("x" + x).setContent("x" + x);
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            row = result.addRow("y" + y);
            for (x = 0; x < map.getWidth(); ++x) {
                row.addCell("x" + x).setContent(Double.valueOf(map.get(y, x)));
            }
        }
        return result;
    }
}

