/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featuregenerator;

import adams.core.option.OptionUtils;
import adams.data.featuregenerator.AbstractDatabaseConnectionFeatureGenerator;
import adams.data.featuregenerator.AbstractFeatureGenerator;
import adams.data.featuregenerator.PassThrough;
import adams.data.heatmap.Heatmap;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class MultiGenerator
extends AbstractDatabaseConnectionFeatureGenerator {
    private static final long serialVersionUID = 805661569976845842L;
    protected AbstractFeatureGenerator[] m_Generators;
    protected boolean m_OverridePrefix;

    public String globalInfo() {
        return "A meta-generator that applies multiple feature generators to the data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "subGenerators", (Object)new AbstractFeatureGenerator[]{new PassThrough()});
        this.m_OptionManager.add("override-prefix", "overridePrefix", (Object)false);
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setSubGenerators(AbstractFeatureGenerator[] value) {
        if (value != null) {
            this.m_Generators = value;
            this.updateDatabaseConnection();
            this.reset();
        } else {
            this.getSystemErr().println(this.getClass().getName() + ": generators cannot be null!");
        }
    }

    public AbstractFeatureGenerator[] getSubGenerators() {
        return this.m_Generators;
    }

    public String subGeneratorsTipText() {
        return "The array of generators to use.";
    }

    public void setOverridePrefix(boolean value) {
        this.m_OverridePrefix = value;
        this.reset();
    }

    public boolean getOverridePrefix() {
        return this.m_OverridePrefix;
    }

    public String overridePrefixTipText() {
        return "If enabled, then this prefix will override the ones specified by the sub-generators.";
    }

    @Override
    protected void updateDatabaseConnection() {
        for (AbstractFeatureGenerator generator : this.m_Generators) {
            if (!(generator instanceof DatabaseConnectionHandler)) continue;
            ((DatabaseConnectionHandler)generator).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected Heatmap processData(Heatmap data) {
        Heatmap input = data;
        Heatmap output = data;
        for (int i = 0; i < this.m_Generators.length; ++i) {
            this.debug("Generator " + (i + 1) + "/" + this.m_Generators.length + ": " + OptionUtils.getCommandLine((Object)this.m_Generators[i]));
            AbstractFeatureGenerator generator = this.m_Generators[i].shallowCopy(true);
            if (this.m_OverridePrefix) {
                generator.setPrefix(this.getPrefix());
            }
            output = generator.generate(input);
            generator.cleanUp();
            input = output;
        }
        this.debug("Finished!");
        Heatmap result = output.getClone();
        return result;
    }
}

