/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.filter.AbstractPreFilter;
import adams.data.filter.Centroid;
import adams.data.filter.Threshold;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public class CropToCentroid
extends AbstractPreFilter<Heatmap> {
    private static final long serialVersionUID = 2270876952032422552L;
    public static final String CROP_LEFT = "Crop.Left";
    public static final String CROP_TOP = "Crop.Top";
    public static final String CROP_RIGHT = "Crop.Right";
    public static final String CROP_BOTTOM = "Crop.Bottom";
    protected int m_Height;
    protected int m_Width;
    protected Centroid m_Centroid;

    public String globalInfo() {
        return "Generates a cropped heatmap centered around the centroid calculated on the pre-filtered data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
        this.m_OptionManager.add("centroid", "centroid", (Object)new Centroid());
    }

    protected AbstractFilter getDefaultFilter() {
        return new Threshold();
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getSystemErr().println("Height must be > 0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the cropped region.";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getSystemErr().println("Width must be > 0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the cropped region.";
    }

    public void setCentroid(Centroid value) {
        this.m_Centroid = value;
        this.reset();
    }

    public Centroid getCentroid() {
        return this.m_Centroid;
    }

    public String centroidTipText() {
        return "The centroid filter to use.";
    }

    protected Heatmap processData(Heatmap filtered, Heatmap original) {
        Heatmap result = original.getHeader(this.m_Height, this.m_Width);
        Centroid centroid = (Centroid)this.m_Centroid.shallowCopy(true);
        Heatmap centered = (Heatmap)centroid.filter(filtered);
        centroid.destroy();
        int c_x = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.X", DataType.NUMERIC)));
        int c_y = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.Y", DataType.NUMERIC)));
        if (this.isDebugOn()) {
            this.debug("Centroid location (y,x): " + c_y + "," + c_x);
        }
        result = CropToCentroid.crop(original, c_y, c_x, this.m_Height, this.m_Width);
        return result;
    }

    public static Heatmap crop(Heatmap original, int centroidY, int centroidX, int height, int width) {
        Heatmap result = original.getHeader(height, width);
        int start_x = centroidX - width / 2;
        int start_y = centroidY - height / 2;
        int end_x = start_x + width;
        int end_y = start_y + height;
        start_x = Math.max(0, start_x);
        start_y = Math.max(0, start_y);
        end_x = Math.min(original.getWidth(), end_x);
        end_y = Math.min(original.getHeight(), end_y);
        result.getReport().setNumericValue(CROP_LEFT, (double)start_x);
        result.getReport().setNumericValue(CROP_TOP, (double)start_y);
        result.getReport().setNumericValue(CROP_RIGHT, (double)end_x);
        result.getReport().setNumericValue(CROP_BOTTOM, (double)end_y);
        for (int y = start_y; y < end_y; ++y) {
            for (int x = start_x; x < end_x; ++x) {
                result.set(y - start_y, x - start_x, original.get(y, x));
            }
        }
        return result;
    }
}

