/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;

public class Submap
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -6589416402799089054L;
    protected int m_Row;
    protected int m_Column;
    protected int m_Height;
    protected int m_Width;

    public String globalInfo() {
        return "Creates a submap, specified by the coordinates of the top-left corner (row and column), width and height.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)0, (Number)0, null);
        this.m_OptionManager.add("col", "column", (Object)0, (Number)0, null);
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
    }

    public void setRow(int value) {
        if (value >= 0) {
            this.m_Row = value;
            this.reset();
        } else {
            this.getSystemErr().println("Row must be >= 0, provided: " + value);
        }
    }

    public int getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the top-left corner, the starting point of the submap (0-based).";
    }

    public void setColumn(int value) {
        if (value >= 0) {
            this.m_Column = value;
            this.reset();
        } else {
            this.getSystemErr().println("Column must be >= 0, provided: " + value);
        }
    }

    public int getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the top-left corner, the starting point of the submap (0-based).";
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getSystemErr().println("Height must be > 0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the submap.";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getSystemErr().println("Width must be > 0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the submap.";
    }

    protected Heatmap processData(Heatmap data) {
        return data.submap(this.m_Row, this.m_Column, this.m_Height, this.m_Width);
    }
}

