/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;

public class Threshold
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -1306518673446335794L;
    protected Type m_Type;
    protected double m_Threshold;

    public String globalInfo() {
        return "Zeroes all intensity values that are either below or above a user-specified threshold, depending on the selected threshold type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.BELOW);
        this.m_OptionManager.add("threshold", "threshold", (Object)90.0, (Number)0.0, (Number)100.0);
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of threshold to use: if " + (Object)((Object)Type.BELOW) + " then all values " + "that fall below the threshold are zeroed, if " + (Object)((Object)Type.ABOVE) + " then " + "all values that are above the threshold are zeroed.";
    }

    public void setThreshold(double value) {
        this.m_Threshold = value;
        this.reset();
    }

    public double getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold in percent (0.0 - 100.0).";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getHeader();
        double thr = (data.getMax() - data.getMin()) * this.m_Threshold / 100.0 + data.getMin();
        block4: for (int i = 0; i < data.size(); ++i) {
            double value = data.get(i);
            switch (this.m_Type) {
                case BELOW: {
                    if (!(value >= thr)) continue block4;
                    result.set(i, value);
                    continue block4;
                }
                case ABOVE: {
                    if (!(value <= thr)) continue block4;
                    result.set(i, value);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
                }
            }
        }
        return result;
    }

    public static enum Type {
        ABOVE,
        BELOW;

    }
}

