/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmap;

import adams.data.heatmap.Heatmap;
import adams.data.statistics.InformativeStatistic;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HeatmapStatistic
implements InformativeStatistic {
    public static String WIDTH = "Map width";
    public static String HEIGHT = "Map height";
    public static String MINIMUM = "Minimum";
    public static String MAXIMUM = "Maximum";
    public static String COUNT_ZEROES = "Zeroes count";
    public static String COUNT_NONZEROES = "Non-zeroes count";
    protected Hashtable<String, Double> m_Statistics = new Hashtable();
    protected Heatmap m_Heatmap = null;

    public HeatmapStatistic() {
    }

    public HeatmapStatistic(Heatmap map) {
        this();
        this.setHeatmap(map);
    }

    public void setHeatmap(Heatmap value) {
        this.m_Heatmap = value;
        this.calculate();
    }

    public Heatmap getHeatmap() {
        return this.m_Heatmap;
    }

    protected void calculate() {
        this.m_Statistics.clear();
        this.m_Statistics.put(HEIGHT, 0.0);
        this.m_Statistics.put(WIDTH, 0.0);
        this.m_Statistics.put(MINIMUM, 0.0);
        this.m_Statistics.put(MAXIMUM, 0.0);
        this.m_Statistics.put(COUNT_ZEROES, 0.0);
        this.m_Statistics.put(COUNT_NONZEROES, 0.0);
        if (this.m_Heatmap == null) {
            return;
        }
        double zeroes = 0.0;
        double nonZeroes = 0.0;
        for (int i = 0; i < this.m_Heatmap.size(); ++i) {
            if (this.m_Heatmap.get(i) == 0.0) {
                zeroes += 1.0;
                continue;
            }
            nonZeroes += 1.0;
        }
        this.m_Statistics.put(HEIGHT, Double.valueOf(this.m_Heatmap.getHeight()));
        this.m_Statistics.put(WIDTH, Double.valueOf(this.m_Heatmap.getWidth()));
        this.m_Statistics.put(MINIMUM, this.m_Heatmap.getMin());
        this.m_Statistics.put(MAXIMUM, this.m_Heatmap.getMax());
        this.m_Statistics.put(COUNT_ZEROES, zeroes);
        this.m_Statistics.put(COUNT_NONZEROES, nonZeroes);
    }

    public String getStatisticDescription() {
        if (this.m_Heatmap == null) {
            return "Statistics";
        }
        return this.m_Heatmap.getID();
    }

    public Enumeration<String> statisticNames() {
        Vector<String> result = new Vector<String>(this.m_Statistics.keySet());
        Collections.sort(result);
        return result.elements();
    }

    public double getStatistic(String name) {
        return this.m_Statistics.get(name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getStatisticDescription());
        result.append("\n");
        Enumeration<String> names = this.statisticNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            result.append(name + ": " + this.getStatistic(name));
            result.append("\n");
        }
        return result.toString();
    }
}

