/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.data.heatmap.Heatmap;
import adams.data.instances.AbstractInstanceGenerator;
import adams.data.instances.HeatmapArffUtils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import java.util.ArrayList;
import java.util.List;
import weka.core.Attribute;
import weka.core.Utils;

public abstract class AbstractFieldInstanceGenerator
extends AbstractInstanceGenerator<Heatmap> {
    private static final long serialVersionUID = -5751743124545585684L;
    protected Field[] m_Fields;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "fields", (Object)new Field[0]);
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return new DatabaseConnection();
    }

    public void setFields(Field[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public Field[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to add to the output.";
    }

    protected void checkHeader(Heatmap data) {
        int size = this.m_OutputHeader.numAttributes();
        if (this.m_AddDatabaseID) {
            --size;
        }
        if (size != this.m_Fields.length) {
            throw new IllegalStateException("Number of fields and output attributes differ (" + data + "): " + this.m_Fields.length + " != " + size);
        }
    }

    protected Attribute createAttribute(Field field, StringBuilder names) {
        if (names.length() > 0) {
            names.append(",");
        }
        names.append(HeatmapArffUtils.getFieldName((AbstractField)field));
        if (field.getDataType() == DataType.NUMERIC) {
            return new Attribute(HeatmapArffUtils.getFieldName((AbstractField)field));
        }
        if (field.getDataType() == DataType.BOOLEAN) {
            ArrayList<String> attValues = new ArrayList<String>();
            attValues.add("false");
            attValues.add("true");
            return new Attribute(HeatmapArffUtils.getFieldName((AbstractField)field), attValues);
        }
        return new Attribute(HeatmapArffUtils.getFieldName((AbstractField)field), (List)null);
    }

    protected void addFields(Heatmap data, double[] values) {
        if (data.hasReport()) {
            Report report = data.getReport();
            for (Field target : this.m_Fields) {
                int index = this.m_OutputHeader.attribute(HeatmapArffUtils.getFieldName((AbstractField)target)).index();
                values[index] = Utils.missingValue();
                if (!report.hasValue((AbstractField)target)) continue;
                values[index] = target.getDataType() == DataType.NUMERIC ? report.getDoubleValue((AbstractField)target) : (target.getDataType() == DataType.BOOLEAN ? (double)this.m_OutputHeader.attribute(index).indexOfValue(report.getBooleanValue((AbstractField)target) != false ? "true" : "false") : (double)this.m_OutputHeader.attribute(index).addStringValue("" + report.getValue((AbstractField)target)));
            }
        }
    }
}

