/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap;

import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.filter.Normalize;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.gui.chooser.HeatmapFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.SearchPanel;
import adams.gui.event.FilterEvent;
import adams.gui.event.FilterListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.FilterDialog;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.image.plugins.AbstractImageFilter;
import adams.gui.visualization.image.plugins.ImageJTransformer;
import adams.gui.visualization.image.plugins.ImageMagick;
import adams.gui.visualization.image.plugins.JAITransformer;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeatmapViewerPanel
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
FilterListener<Heatmap>,
SendToActionSupporter {
    private static final long serialVersionUID = -2642034258827736757L;
    public static final String SESSION_FILE = "HeatmapViewerPanelSession.props";
    protected static Properties m_Properties;
    protected BaseTabbedPane m_TabbedPane;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileReloadCurrent;
    protected JMenuItem m_MenuItemFileReloadAll;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileCloseCurrent;
    protected JMenuItem m_MenuItemFileCloseAll;
    protected JMenuItem m_MenuItemProcessFilterHeatmap;
    protected JMenuItem m_MenuItemProcessFilterAllHeatmaps;
    protected JMenuItem m_MenuItemProcessApplyImageJ;
    protected JMenuItem m_MenuItemProcessApplyJAI;
    protected JMenuItem m_MenuItemProcessApplyImageMagick;
    protected JMenuItem m_MenuItemViewShowCentroid;
    protected JMenuItem m_MenuItemViewShowSpreadsheet;
    protected JMenuItem m_MenuItemViewShowStatistics;
    protected JMenuItem m_MenuItemViewShowNotes;
    protected HeatmapFileChooser m_FileChooser;
    protected AbstractFilter<Heatmap> m_CurrentFilter;
    protected FilterDialog m_DialogFilter;
    protected boolean m_FilterOverlayOriginalData;
    protected boolean m_FilterAll;
    protected SearchPanel m_SearchPanel;

    protected void initialize() {
        super.initialize();
        Properties props = this.getProperties();
        this.m_FileChooser = new HeatmapFileChooser(props.getString("InitialDir", "%h"));
        this.m_CurrentFilter = new Normalize();
        this.m_FilterAll = false;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add(panel, "Center");
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_TabbedPane.setTabLayoutPolicy(1);
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        panel.add((Component)this.m_TabbedPane, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", true, null);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                HeatmapViewerPanel.this.search(HeatmapViewerPanel.this.m_SearchPanel.getSearchText(), HeatmapViewerPanel.this.m_SearchPanel.isRegularExpression());
            }
        });
        JPanel panel2 = new JPanel(new FlowLayout(2));
        panel2.add((Component)this.m_SearchPanel);
        panel.add((Component)panel2, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            JMenuBar result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.load();
                }
            });
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Reload current");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"F5"));
            menuitem.setIcon(GUIHelper.getIcon((String)"refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.reloadCurrent();
                }
            });
            this.m_MenuItemFileReloadCurrent = menuitem;
            menuitem = new JMenuItem("Reload all");
            menu.add(menuitem);
            menuitem.setMnemonic('e');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F5"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.reloadAll();
                }
            });
            this.m_MenuItemFileReloadAll = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.closeCurrent();
                }
            });
            this.m_MenuItemFileCloseCurrent = menuitem;
            menuitem = new JMenuItem("Close all tabs");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete_all.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.closeAll();
                }
            });
            this.m_MenuItemFileCloseAll = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.close();
                }
            });
            menu = new JMenu("Process");
            result.add(menu);
            menu.setMnemonic('P');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter heatmap...");
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.m_FilterAll = false;
                    HeatmapViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterHeatmap = menuitem;
            menuitem = new JMenuItem("Filter all heatmaps...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.m_FilterAll = true;
                    HeatmapViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterHeatmap = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Apply ImageJ...");
            menu.add(menuitem);
            menuitem.setMnemonic('I');
            menuitem.setIcon(GUIHelper.getIcon((String)"imagej.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyImageJ(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyImageJ = menuitem;
            menuitem = new JMenuItem("Apply JAI...");
            menu.add(menuitem);
            menuitem.setMnemonic('J');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyJAI(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyJAI = menuitem;
            menuitem = new JMenuItem("Apply ImageMagick...");
            menu.add(menuitem);
            menuitem.setMnemonic('M');
            menuitem.setIcon(GUIHelper.getIcon((String)"imagemagick.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyImageMagick(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyImageMagick = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Show centroid");
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('c');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean show = HeatmapViewerPanel.this.m_MenuItemViewShowCentroid.isSelected();
                    for (int i = 0; i < HeatmapViewerPanel.this.m_TabbedPane.getTabCount(); ++i) {
                        HeatmapViewerPanel.this.getPanelAt(i).setShowCentroid(show);
                        if (!show) continue;
                        HeatmapViewerPanel.this.showStatus("Calculating centroid " + (i + 1) + "/" + HeatmapViewerPanel.this.m_TabbedPane.getTabCount() + "...");
                    }
                    HeatmapViewerPanel.this.showStatus("");
                }
            });
            this.m_MenuItemViewShowCentroid = menuitem;
            menuitem = new JMenuItem("Show spreadsheet...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('s');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"spreadsheet.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showSpreadsheet();
                }
            });
            this.m_MenuItemViewShowSpreadsheet = menuitem;
            menuitem = new JMenuItem("Show statistics...");
            menu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setIcon(GUIHelper.getIcon((String)"properties.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showStatistics();
                }
            });
            this.m_MenuItemViewShowStatistics = menuitem;
            menuitem = new JMenuItem("Show notes...");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getIcon((String)"report.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showNotes();
                }
            });
            this.m_MenuItemViewShowNotes = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    public HeatmapPanel getPanelAt(int index) {
        HeatmapPanel result = null;
        if (index != -1) {
            result = (HeatmapPanel)((Object)this.m_TabbedPane.getComponentAt(index));
        }
        return result;
    }

    public HeatmapPanel getCurrentPanel() {
        return this.getPanelAt(this.m_TabbedPane.getSelectedIndex());
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.m_TabbedPane.getTabCount() > 0;
        this.m_MenuItemFileSaveAs.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileReloadCurrent.setEnabled(dataLoaded && this.getCurrentPanel().canReload());
        this.m_MenuItemFileReloadAll.setEnabled(dataLoaded);
        this.m_MenuItemFileCloseCurrent.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileCloseAll.setEnabled(dataLoaded);
        this.m_MenuItemProcessFilterHeatmap.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyImageJ.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyJAI.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyImageMagick.setEnabled(dataLoaded);
        this.m_MenuItemViewShowSpreadsheet.setEnabled(dataLoaded);
        this.m_MenuItemViewShowStatistics.setEnabled(dataLoaded);
        this.m_MenuItemViewShowNotes.setEnabled(dataLoaded);
    }

    protected void reloadCurrent() {
        HeatmapPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.reload();
        this.m_TabbedPane.setTitleAt(this.m_TabbedPane.getSelectedIndex(), panel.getTitle());
    }

    protected void reloadAll() {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            HeatmapPanel panel = this.getPanelAt(i);
            panel.reload();
            this.m_TabbedPane.setTitleAt(i, panel.getTitle());
        }
    }

    public void closeCurrent() {
        if (this.m_TabbedPane.getSelectedIndex() != -1) {
            this.m_TabbedPane.removeTabAt(this.m_TabbedPane.getSelectedIndex());
        }
    }

    public void closeAll() {
        this.m_TabbedPane.removeAll();
    }

    protected HeatmapPanel newPanel(Heatmap map) {
        HeatmapPanel result = new HeatmapPanel(this);
        if (this.m_MenuItemViewShowCentroid != null) {
            result.setShowCentroid(this.m_MenuItemViewShowCentroid.isSelected());
        }
        result.setSearchPanelVisible(false);
        result.setHeatmap(map);
        return result;
    }

    public void load(File[] files, final AbstractHeatmapReader reader) {
        for (final File file : files) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    HeatmapViewerPanel.this.showStatus("Loading file: " + file);
                    reader.setInput(new PlaceholderFile(file));
                    Vector maps = reader.read();
                    if (maps.size() == 0) {
                        GUIHelper.showErrorMessage((Component)((Object)HeatmapViewerPanel.this), (String)("Failed to read heatmap from:\n" + reader.getInput()));
                        HeatmapViewerPanel.this.showStatus("");
                        return;
                    }
                    HeatmapPanel panel = HeatmapViewerPanel.this.newPanel((Heatmap)maps.get(0));
                    panel.setReader(reader);
                    HeatmapViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    HeatmapViewerPanel.this.showStatus("");
                }
            };
            SwingUtilities.invokeLater(run);
        }
        this.showStatus("");
    }

    public void load(File file) {
        AbstractHeatmapReader reader = (AbstractHeatmapReader)this.m_FileChooser.getReaderForFile(file);
        if (reader == null) {
            this.m_FileChooser.setSelectedFile(file);
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to automatically determine reader for file, please choose appropriate one:\n" + file));
            this.load();
            return;
        }
        this.load(new File[]{file}, reader);
    }

    public void load() {
        this.m_FileChooser.setMultiSelectionEnabled(true);
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        this.load(this.m_FileChooser.getSelectedFiles(), (AbstractHeatmapReader)this.m_FileChooser.getReader());
    }

    protected void saveAs() {
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        Heatmap map = this.getCurrentPanel().getHeatmap();
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        AbstractDataContainerWriter writer = this.m_FileChooser.getWriter();
        writer.setOutput(file);
        if (!writer.write((DataContainer)map)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write heatmap to '" + file + "'!\nCheck console for error message."));
        }
    }

    public void close() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    protected void filter() {
        if (this.m_DialogFilter == null) {
            this.m_DialogFilter = this.getParentDialog() != null ? new FilterDialog(this.getParentDialog()) : new FilterDialog(this.getParentFrame());
            this.m_DialogFilter.setFilterListener((FilterListener)this);
        }
        this.m_DialogFilter.setFilter(this.m_CurrentFilter);
        this.m_DialogFilter.setOverlayOriginalData(this.m_FilterOverlayOriginalData);
        this.m_DialogFilter.setLocationRelativeTo((Component)((Object)this));
        this.m_DialogFilter.setVisible(true);
    }

    public void filter(final FilterEvent<Heatmap> e) {
        int i;
        int[] indices;
        this.m_CurrentFilter = e.getFilter();
        this.m_FilterOverlayOriginalData = e.getOverlayOriginalData();
        int count = this.m_TabbedPane.getTabCount();
        if (this.m_FilterAll) {
            indices = new int[count];
            for (i = 0; i < count; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[]{this.m_TabbedPane.getSelectedIndex()};
        }
        for (i = 0; i < indices.length; ++i) {
            final int index = indices[i];
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    AbstractFilter filter = e.getFilter().shallowCopy();
                    HeatmapPanel panel = HeatmapViewerPanel.this.getPanelAt(index);
                    Heatmap filtered = (Heatmap)filter.filter((DataContainer)panel.getHeatmap());
                    filter.cleanUp();
                    if (e.getOverlayOriginalData()) {
                        panel = HeatmapViewerPanel.this.newPanel(filtered);
                        HeatmapViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    } else {
                        panel.setHeatmap(filtered);
                        HeatmapViewerPanel.this.m_TabbedPane.setTitleAt(index, panel.getTitle());
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    protected void applyImageFilter(HeatmapPanel panel, AbstractImageFilter filter) {
        double scale = panel.getImagePanel().getScale();
        String result = filter.execute(panel.getImagePanel());
        panel.getImagePanel().setScale(scale);
        if (result != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to filter heatmap image:\n" + result));
        }
    }

    protected void applyImageJ(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new ImageJTransformer());
    }

    protected void applyJAI(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new JAITransformer());
    }

    protected void applyImageMagick(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new ImageMagick());
    }

    public void search(String text, boolean isRegExp) {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            this.getPanelAt(i).search(text, isRegExp);
        }
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public Class[] getSendToClasses() {
        return new Class[]{JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getCurrentPanel() != null;
    }

    public Object getSendToItem(Class[] cls) {
        HeatmapPanel result = null;
        if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getCurrentPanel() != null) {
            result = this.getCurrentPanel();
        }
        return result;
    }

    public synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                String props = ((Object)((Object)this)).getClass().getName().replaceAll("\\.", "/") + ".props";
                m_Properties = Properties.read((String)props);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }
}

