/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;

public class Rotate
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -1306518673446335794L;
    protected Rotation m_Rotation;

    public String globalInfo() {
        return "Rotates a heatmap by a specified number of degrees clockwise.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rotation", "rotation", (Object)Rotation.ROTATE_180_DEGREES);
    }

    public void setRotation(Rotation value) {
        this.m_Rotation = value;
        this.reset();
    }

    public Rotation getRotation() {
        return this.m_Rotation;
    }

    public String rotationTipText() {
        return "The type of rotation to perform on the heatmap.";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result;
        if (this.m_Rotation == Rotation.ROTATE_90_DEGREES) {
            result = data.getHeader(data.getWidth(), data.getHeight());
            for (int y = 0; y < data.getHeight(); ++y) {
                for (int x = 0; x < data.getWidth(); ++x) {
                    result.set(x, result.getWidth() - y - 1, data.get(y, x));
                }
            }
        } else if (this.m_Rotation == Rotation.ROTATE_180_DEGREES) {
            result = data.getHeader(data.getHeight(), data.getWidth());
            for (int y = 0; y < data.getHeight(); ++y) {
                for (int x = 0; x < data.getWidth(); ++x) {
                    result.set(result.getHeight() - y - 1, result.getWidth() - x - 1, data.get(y, x));
                }
            }
        } else if (this.m_Rotation == Rotation.ROTATE_270_DEGREES) {
            result = data.getHeader(data.getWidth(), data.getHeight());
            for (int y = 0; y < data.getHeight(); ++y) {
                for (int x = 0; x < data.getWidth(); ++x) {
                    result.set(result.getHeight() - x - 1, y, data.get(y, x));
                }
            }
        } else {
            throw new IllegalStateException("Unhandled rotation: " + (Object)((Object)this.m_Rotation));
        }
        return result;
    }

    public static enum Rotation {
        ROTATE_90_DEGREES,
        ROTATE_180_DEGREES,
        ROTATE_270_DEGREES;

    }
}

