/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public class SubtractField
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -7041791005249685082L;
    protected Field m_Field;

    public String globalInfo() {
        return "Subtracts the value of the numeric field from all non-zero heatmap values.\nValues that fall below zero are automatically set to zero (minimum value for a heatmap).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)new Field("Temperature", DataType.NUMERIC));
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The (numeric) field in the report to subtract from the heatmap values.";
    }

    protected Heatmap processData(Heatmap data) {
        if (!data.hasReport()) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "No report attached!");
            return result;
        }
        if (!data.getReport().hasValue((AbstractField)this.m_Field)) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Field '" + this.m_Field + "' not found in report!");
            return result;
        }
        if (!(data.getReport().getValue((AbstractField)this.m_Field) instanceof Double)) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Field '" + this.m_Field + "' not numeric!");
            return result;
        }
        double subtract = data.getReport().getDoubleValue((AbstractField)this.m_Field);
        Heatmap result = data.getHeader();
        Double[] values = data.toDoubleArray();
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > 0.0)) continue;
            Double[] doubleArray = values;
            int n = i;
            Double.valueOf(doubleArray[n] - subtract);
            if (!(values[i] < 0.0)) continue;
            values[i] = 0.0;
        }
        result.set(values);
        return result;
    }
}

