/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.HeatmapToSpreadSheet;
import adams.data.io.input.FloatMatrixHeatmapReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class HeatmapSpreadSheetHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -2780002972029225999L;

    public String globalInfo() {
        return "Displays a heatmap as a spreadsheet.";
    }

    public String[] getExtensions() {
        return new String[]{"dat"};
    }

    protected PreviewPanel createPreview(File file) {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        FloatMatrixHeatmapReader reader = new FloatMatrixHeatmapReader();
        reader.setInput(new PlaceholderFile(file));
        List maps = reader.read();
        if (maps.size() > 0) {
            HeatmapToSpreadSheet hm2ss = new HeatmapToSpreadSheet();
            hm2ss.setInput(maps.get(0));
            String msg = hm2ss.convert();
            SpreadSheetTableModel model = msg == null ? new SpreadSheetTableModel((SpreadSheet)hm2ss.getOutput()) : new SpreadSheetTableModel();
            SpreadSheetTable table = new SpreadSheetTable(model);
            table.setNumDecimals(3);
            result.add((Component)new BaseScrollPane((Component)table), (Object)"Center");
        }
        return new PreviewPanel((JComponent)result);
    }
}

