/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap;

import adams.data.filter.Centroid;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.visualization.heatmap.AbstractHeatmapOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import weka.core.Utils;

public class CentroidOverlay
extends AbstractHeatmapOverlay {
    private static final long serialVersionUID = -2945211815191636810L;
    protected double[] m_Centroid;
    protected Color m_Color;

    public String globalInfo() {
        return "Paints the centroid's location over the heatmap image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    protected void reset() {
        super.reset();
        this.m_Centroid = null;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color for the overlay.";
    }

    protected void calcCentroid() {
        Centroid centroid = new Centroid();
        Heatmap map = (Heatmap)centroid.filter(this.m_HeatmapPanel.getHeatmap());
        this.m_Centroid = new double[2];
        this.m_Centroid[0] = map.getReport().getDoubleValue((AbstractField)new Field("Centroid.X", DataType.NUMERIC));
        this.m_Centroid[1] = map.getReport().getDoubleValue((AbstractField)new Field("Centroid.Y", DataType.NUMERIC));
    }

    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Centroid == null) {
            this.calcCentroid();
        }
        if (this.m_Centroid[0] == -1.0 || this.m_Centroid[1] == -1.0) {
            this.getLogger().severe("Cannot paint centroid: " + Utils.arrayToString((Object)this.m_Centroid));
            return;
        }
        int x = (int)Math.round(this.m_Centroid[0]);
        int y = (int)Math.round(this.m_Centroid[1]);
        g.setColor(this.m_Color);
        g.drawLine(x, 0, x, panel.getOwner().getHeight() - 1);
        g.drawLine(0, y, panel.getOwner().getWidth() - 1, y);
    }
}

