/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.data.filter.Normalize;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.gui.chooser.HeatmapFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.SearchPanel;
import adams.gui.event.FilterEvent;
import adams.gui.event.FilterListener;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.FilterDialog;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.image.plugins.AbstractImageFilter;
import adams.gui.visualization.image.plugins.ImageJTransformer;
import adams.gui.visualization.image.plugins.ImageMagick;
import adams.gui.visualization.image.plugins.JAITransformer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeatmapViewerPanel
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
FilterListener<Heatmap>,
SendToActionSupporter,
CleanUpHandler {
    private static final long serialVersionUID = -2642034258827736757L;
    public static final String SESSION_FILE = "HeatmapViewerPanelSession.props";
    protected static Properties m_Properties;
    protected BaseTabbedPane m_TabbedPane;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileReloadCurrent;
    protected JMenuItem m_MenuItemFileReloadAll;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileCloseCurrent;
    protected JMenuItem m_MenuItemFileCloseAll;
    protected JMenuItem m_MenuItemProcessFilterHeatmap;
    protected JMenuItem m_MenuItemProcessFilterAllHeatmaps;
    protected JMenuItem m_MenuItemProcessApplyImageJ;
    protected JMenuItem m_MenuItemProcessApplyJAI;
    protected JMenuItem m_MenuItemProcessApplyImageMagick;
    protected JMenuItem m_MenuItemViewShowCentroid;
    protected JMenuItem m_MenuItemViewShowSpreadsheet;
    protected JMenuItem m_MenuItemViewShowStatistics;
    protected JMenuItem m_MenuItemViewShowNotes;
    protected JMenu m_MenuViewZoom;
    protected JMenuItem m_MenuItemViewZoomIn;
    protected JMenuItem m_MenuItemViewZoomOut;
    protected JMenuItem m_MenuItemViewColorGenerator;
    protected HeatmapFileChooser m_FileChooser;
    protected AbstractFilter<Heatmap> m_CurrentFilter;
    protected FilterDialog m_DialogFilter;
    protected boolean m_FilterOverlayOriginalData;
    protected boolean m_FilterAll;
    protected SearchPanel m_SearchPanel;
    protected GenericObjectEditorDialog m_DialogColorGenerator;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;

    protected void initialize() {
        super.initialize();
        Properties props = this.getProperties();
        this.m_FileChooser = new HeatmapFileChooser(props.getPath("InitialDir", "%h"));
        this.m_CurrentFilter = new Normalize();
        this.m_FilterAll = false;
        this.m_DialogColorGenerator = null;
        this.m_RecentFilesHandler = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.add(panel, "Center");
        this.m_TabbedPane = new BaseTabbedPane();
        this.m_TabbedPane.setTabLayoutPolicy(1);
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        panel.add((Component)this.m_TabbedPane, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", true, null);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                HeatmapViewerPanel.this.search(HeatmapViewerPanel.this.m_SearchPanel.getSearchText(), HeatmapViewerPanel.this.m_SearchPanel.isRegularExpression());
            }
        });
        JPanel panel2 = new JPanel(new FlowLayout(2));
        panel2.add((Component)this.m_SearchPanel);
        panel.add((Component)panel2, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            JMenuBar result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.load();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, this.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    HeatmapViewerPanel.this.load(new File[]{((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile()}, (AbstractHeatmapReader)((Object)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler()));
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Reload current");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"F5"));
            menuitem.setIcon(GUIHelper.getIcon((String)"refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.reloadCurrent();
                }
            });
            this.m_MenuItemFileReloadCurrent = menuitem;
            menuitem = new JMenuItem("Reload all");
            menu.add(menuitem);
            menuitem.setMnemonic('e');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F5"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.reloadAll();
                }
            });
            this.m_MenuItemFileReloadAll = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.closeCurrent();
                }
            });
            this.m_MenuItemFileCloseCurrent = menuitem;
            menuitem = new JMenuItem("Close all tabs");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"delete_all.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.closeAll();
                }
            });
            this.m_MenuItemFileCloseAll = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.close();
                }
            });
            menu = new JMenu("Process");
            result.add(menu);
            menu.setMnemonic('P');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter heatmap...");
            menu.add(menuitem);
            menuitem.setMnemonic('F');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed F"));
            menuitem.setIcon(GUIHelper.getIcon((String)"run.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.m_FilterAll = false;
                    HeatmapViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterHeatmap = menuitem;
            menuitem = new JMenuItem("Filter all heatmaps...");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.m_FilterAll = true;
                    HeatmapViewerPanel.this.filter();
                }
            });
            this.m_MenuItemProcessFilterAllHeatmaps = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Apply ImageJ...");
            menu.add(menuitem);
            menuitem.setMnemonic('I');
            menuitem.setIcon(GUIHelper.getIcon((String)"imagej.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyImageJ(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyImageJ = menuitem;
            menuitem = new JMenuItem("Apply JAI...");
            menu.add(menuitem);
            menuitem.setMnemonic('J');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyJAI(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyJAI = menuitem;
            menuitem = new JMenuItem("Apply ImageMagick...");
            menu.add(menuitem);
            menuitem.setMnemonic('M');
            menuitem.setIcon(GUIHelper.getIcon((String)"imagemagick.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.applyImageMagick(HeatmapViewerPanel.this.getCurrentPanel());
                }
            });
            this.m_MenuItemProcessApplyImageMagick = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setMnemonic('Z');
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            submenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HeatmapViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuViewZoom = submenu;
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed I"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().getImagePanel().setScale(HeatmapViewerPanel.this.getCurrentPanel().getImagePanel().getScale() * 1.5);
                }
            });
            this.m_MenuItemViewZoomIn = menuitem;
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().getImagePanel().setScale(HeatmapViewerPanel.this.getCurrentPanel().getImagePanel().getScale() / 1.5);
                }
            });
            this.m_MenuItemViewZoomOut = menuitem;
            int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800, 1600};
            String[] shortcuts = new String[]{"F", "", "", "", "", "1", "", "2", "4", "", ""};
            submenu.addSeparator();
            for (int i = 0; i < zooms.length; ++i) {
                final int fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                submenu.add(menuitem);
                if (shortcuts[i].length() > 0) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke((String)shortcuts[i]));
                }
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HeatmapViewerPanel.this.zoom(fZoom);
                    }
                });
            }
            menuitem = new JCheckBoxMenuItem("Show centroid");
            menu.add(menuitem);
            menuitem.setSelected(false);
            menuitem.setMnemonic('c');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean show = HeatmapViewerPanel.this.m_MenuItemViewShowCentroid.isSelected();
                    for (int i = 0; i < HeatmapViewerPanel.this.m_TabbedPane.getTabCount(); ++i) {
                        HeatmapViewerPanel.this.getPanelAt(i).setShowCentroid(show);
                        if (!show) continue;
                        HeatmapViewerPanel.this.showStatus("Calculating centroid " + (i + 1) + "/" + HeatmapViewerPanel.this.m_TabbedPane.getTabCount() + "...");
                    }
                    HeatmapViewerPanel.this.showStatus("");
                }
            });
            this.m_MenuItemViewShowCentroid = menuitem;
            menuitem = new JMenuItem("Color generator...");
            menu.add(menuitem);
            menuitem.setMnemonic('G');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.selectColorGenerator();
                }
            });
            this.m_MenuItemViewColorGenerator = menuitem;
            menuitem = new JMenuItem("Show spreadsheet...");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('s');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"spreadsheet.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showSpreadsheet();
                }
            });
            this.m_MenuItemViewShowSpreadsheet = menuitem;
            menuitem = new JMenuItem("Show statistics...");
            menu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setIcon(GUIHelper.getIcon((String)"properties.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showStatistics();
                }
            });
            this.m_MenuItemViewShowStatistics = menuitem;
            menuitem = new JMenuItem("Show notes...");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getIcon((String)"report.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeatmapViewerPanel.this.getCurrentPanel().showNotes();
                }
            });
            this.m_MenuItemViewShowNotes = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    public HeatmapPanel getPanelAt(int index) {
        HeatmapPanel result = null;
        if (index != -1) {
            result = (HeatmapPanel)((Object)this.m_TabbedPane.getComponentAt(index));
        }
        return result;
    }

    public HeatmapPanel getCurrentPanel() {
        return this.getPanelAt(this.m_TabbedPane.getSelectedIndex());
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.m_TabbedPane.getTabCount() > 0;
        this.m_MenuItemFileSaveAs.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileReloadCurrent.setEnabled(dataLoaded && this.getCurrentPanel().canReload());
        this.m_MenuItemFileReloadAll.setEnabled(dataLoaded);
        this.m_MenuItemFileCloseCurrent.setEnabled(this.getCurrentPanel() != null);
        this.m_MenuItemFileCloseAll.setEnabled(dataLoaded);
        this.m_MenuItemProcessFilterHeatmap.setEnabled(dataLoaded);
        this.m_MenuItemProcessFilterAllHeatmaps.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyImageJ.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyJAI.setEnabled(dataLoaded);
        this.m_MenuItemProcessApplyImageMagick.setEnabled(dataLoaded);
        this.m_MenuViewZoom.setEnabled(dataLoaded);
        this.m_MenuItemViewZoomIn.setEnabled(dataLoaded);
        this.m_MenuItemViewZoomOut.setEnabled(dataLoaded);
        this.m_MenuItemViewColorGenerator.setEnabled(dataLoaded);
        this.m_MenuItemViewShowSpreadsheet.setEnabled(dataLoaded);
        this.m_MenuItemViewShowStatistics.setEnabled(dataLoaded);
        this.m_MenuItemViewShowNotes.setEnabled(dataLoaded);
    }

    protected void reloadCurrent() {
        HeatmapPanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        panel.reload();
        this.m_TabbedPane.setTitleAt(this.m_TabbedPane.getSelectedIndex(), panel.getTitle());
    }

    protected void reloadAll() {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            HeatmapPanel panel = this.getPanelAt(i);
            panel.reload();
            this.m_TabbedPane.setTitleAt(i, panel.getTitle());
        }
    }

    public void closeCurrent() {
        if (this.m_TabbedPane.getSelectedIndex() != -1) {
            this.m_TabbedPane.removeTabAt(this.m_TabbedPane.getSelectedIndex());
        }
    }

    public void closeAll() {
        this.m_TabbedPane.removeAll();
    }

    protected HeatmapPanel newPanel(Heatmap map) {
        HeatmapPanel result = new HeatmapPanel(this);
        if (this.m_MenuItemViewShowCentroid != null) {
            result.setShowCentroid(this.m_MenuItemViewShowCentroid.isSelected());
        }
        result.setSearchPanelVisible(false);
        result.setHeatmap(map);
        return result;
    }

    public void load(File[] files, final AbstractHeatmapReader reader) {
        for (final File file : files) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    HeatmapViewerPanel.this.showStatus("Loading file: " + file);
                    reader.setInput(new PlaceholderFile(file));
                    List maps = reader.read();
                    if (maps.size() == 0) {
                        GUIHelper.showErrorMessage((Component)((Object)HeatmapViewerPanel.this), (String)("Failed to read heatmap from:\n" + reader.getInput()));
                        HeatmapViewerPanel.this.showStatus("");
                        return;
                    }
                    HeatmapPanel panel = HeatmapViewerPanel.this.newPanel((Heatmap)maps.get(0));
                    panel.setReader(reader);
                    HeatmapViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    HeatmapViewerPanel.this.showStatus("");
                    if (HeatmapViewerPanel.this.m_RecentFilesHandler != null) {
                        HeatmapViewerPanel.this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
        this.showStatus("");
    }

    public void load(File file) {
        AbstractHeatmapReader reader = (AbstractHeatmapReader)this.m_FileChooser.getReaderForFile(file);
        if (reader == null) {
            this.m_FileChooser.setSelectedFile(file);
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to automatically determine reader for file, please choose appropriate one:\n" + file));
            this.load();
            return;
        }
        this.load(new File[]{file}, reader);
    }

    public void load() {
        this.m_FileChooser.setMultiSelectionEnabled(true);
        int retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.load(this.m_FileChooser.getSelectedFiles(), (AbstractHeatmapReader)((Object)this.m_FileChooser.getReader()));
    }

    protected void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        Heatmap map = this.getCurrentPanel().getHeatmap();
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        AbstractDataContainerWriter writer = (AbstractDataContainerWriter)this.m_FileChooser.getWriter();
        writer.setOutput(file);
        if (!writer.write((DataContainer)map)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write heatmap to '" + file + "'!\nCheck console for error message."));
        }
    }

    public void close() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    protected void filter() {
        if (this.m_DialogFilter == null) {
            this.m_DialogFilter = this.getParentDialog() != null ? new FilterDialog(this.getParentDialog()) : new FilterDialog(this.getParentFrame());
            this.m_DialogFilter.setFilterListener((FilterListener)this);
        }
        this.m_DialogFilter.setFilter(this.m_CurrentFilter);
        this.m_DialogFilter.setOverlayOriginalData(this.m_FilterOverlayOriginalData);
        this.m_DialogFilter.setLocationRelativeTo((Component)((Object)this));
        this.m_DialogFilter.setVisible(true);
    }

    public void filter(final FilterEvent<Heatmap> e) {
        int i;
        int[] indices;
        this.m_CurrentFilter = e.getFilter();
        this.m_FilterOverlayOriginalData = e.getOverlayOriginalData();
        int count = this.m_TabbedPane.getTabCount();
        if (this.m_FilterAll) {
            indices = new int[count];
            for (i = 0; i < count; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[]{this.m_TabbedPane.getSelectedIndex()};
        }
        for (i = 0; i < indices.length; ++i) {
            final int index = indices[i];
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    AbstractFilter filter = e.getFilter().shallowCopy();
                    HeatmapPanel panel = HeatmapViewerPanel.this.getPanelAt(index);
                    Heatmap filtered = (Heatmap)filter.filter((DataContainer)panel.getHeatmap());
                    filter.cleanUp();
                    if (e.getOverlayOriginalData()) {
                        panel = HeatmapViewerPanel.this.newPanel(filtered);
                        HeatmapViewerPanel.this.m_TabbedPane.addTab(panel.getTitle(), (Component)((Object)panel));
                    } else {
                        panel.setHeatmap(filtered);
                        HeatmapViewerPanel.this.m_TabbedPane.setTitleAt(index, panel.getTitle());
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    protected void applyImageFilter(HeatmapPanel panel, AbstractImageFilter filter) {
        double scale = panel.getImagePanel().getScale();
        String result = filter.execute(panel.getImagePanel());
        panel.getImagePanel().setScale(scale);
        if (result != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to filter heatmap image:\n" + result));
        }
    }

    protected void applyImageJ(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new ImageJTransformer());
    }

    protected void applyJAI(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new JAITransformer());
    }

    protected void applyImageMagick(HeatmapPanel panel) {
        this.applyImageFilter(panel, (AbstractImageFilter)new ImageMagick());
    }

    public void search(String text, boolean isRegExp) {
        for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
            this.getPanelAt(i).search(text, isRegExp);
        }
    }

    protected void zoom(int zoom) {
        this.getCurrentPanel().setZoom((double)zoom / 100.0);
    }

    protected void selectColorGenerator() {
        if (this.m_DialogColorGenerator == null) {
            this.m_DialogColorGenerator = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogColorGenerator.setTitle("Select color generator");
            this.m_DialogColorGenerator.getGOEEditor().setClassType(AbstractColorGradientGenerator.class);
            this.m_DialogColorGenerator.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogColorGenerator.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_DialogColorGenerator.setCurrent((Object)this.getCurrentPanel().getColorGenerator().shallowCopy());
        this.m_DialogColorGenerator.setVisible(true);
        if (this.m_DialogColorGenerator.getResult() != 0) {
            return;
        }
        this.getCurrentPanel().setColorGenerator(((AbstractColorGradientGenerator)this.m_DialogColorGenerator.getCurrent()).shallowCopy());
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    public Class[] getSendToClasses() {
        return new Class[]{JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getCurrentPanel() != null;
    }

    public Object getSendToItem(Class[] cls) {
        HeatmapPanel result = null;
        if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getCurrentPanel() != null) {
            result = this.getCurrentPanel();
        }
        return result;
    }

    public synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                String props = ((Object)((Object)this)).getClass().getName().replaceAll("\\.", "/") + ".props";
                m_Properties = Properties.read((String)props);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public void cleanUp() {
        if (this.m_DialogColorGenerator != null) {
            this.m_DialogColorGenerator.dispose();
            this.m_DialogColorGenerator = null;
        }
    }
}

