/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;
import adams.data.statistics.StatUtils;

public class Normalize
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = 2270876952032422552L;

    public String globalInfo() {
        return "Normalizes the values of a heatmap to have a range of 0 to 1.";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getHeader();
        Number[] values = data.toDoubleArray();
        if ((values = StatUtils.normalize((Number[])values)) == null) {
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Failed to normalize, sum = 0!");
            result.set(data.toDoubleArray());
        } else {
            result.set((Double[])values);
        }
        return result;
    }
}

