/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmap;

import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.heatmap.Heatmap;

public class HeatmapValue
implements DataPoint {
    private static final long serialVersionUID = 7356588902030284681L;
    protected Heatmap m_Parent;
    protected double m_Value;
    protected int m_X;
    protected int m_Y;

    public HeatmapValue() {
        this(0, 0, 0.0);
    }

    public HeatmapValue(int y, int x, double value) {
        if (y < 0) {
            throw new IllegalArgumentException("y cannot be less than 0!");
        }
        if (x < 0) {
            throw new IllegalArgumentException("x cannot be less than 0!");
        }
        this.m_Parent = null;
        this.m_Y = y;
        this.m_X = x;
        this.m_Value = value;
    }

    public void setParent(DataContainer value) {
        this.m_Parent = (Heatmap)value;
    }

    public Heatmap getParent() {
        return this.m_Parent;
    }

    public boolean hasParent() {
        return this.m_Parent != null;
    }

    public int getX() {
        return this.m_X;
    }

    public int getY() {
        return this.m_Y;
    }

    public double getValue() {
        return this.m_Value;
    }

    public void assign(DataPoint other) {
        HeatmapValue value = (HeatmapValue)other;
        this.m_X = value.getX();
        this.m_Y = value.getY();
        this.m_Value = value.getValue();
        this.m_Parent = value.getParent();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        HeatmapValue p = (HeatmapValue)o;
        if (result == 0) {
            result = new Integer(this.getY()).compareTo(new Integer(p.getY()));
        }
        if (result == 0) {
            result = new Integer(this.getX()).compareTo(new Integer(p.getX()));
        }
        if (result == 0) {
            result = new Double(this.getValue()).compareTo(new Double(p.getValue()));
        }
        return result;
    }

    public Object getClone() {
        HeatmapValue result = new HeatmapValue();
        result.assign(this);
        result.setParent(null);
        return result;
    }

    public String toString() {
        String result = "y=" + this.getY();
        result = result + ", x=" + this.getX();
        result = result + ", value=" + this.getValue();
        return result;
    }
}

