/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.data.heatmap.Heatmap;
import adams.data.instances.AbstractFieldInstanceGenerator;
import adams.data.report.Field;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class IntensityInstanceGenerator
extends AbstractFieldInstanceGenerator {
    private static final long serialVersionUID = -8643534190230443073L;
    protected double m_MinIntensity;
    protected double m_MaxIntensity;

    public String globalInfo() {
        return "A generator for turning a heatmap's intensities and fields of its report into weka.core.Instance objects.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-intensity", "minIntensity", (Object)-1.0, (Number)-1.0, null);
        this.m_OptionManager.add("max-intensity", "maxIntensity", (Object)-1.0, (Number)-1.0, null);
    }

    public void setMinIntensity(double value) {
        if (value > 0.0 || value == -1.0) {
            this.m_MinIntensity = value;
            this.reset();
        } else {
            this.getLogger().severe(((Object)((Object)this)).getClass().getName() + ": only positive numbers or -1 are allowed for the minimum intensity " + "(provided: " + value + ")!");
        }
    }

    public double getMinIntensity() {
        return this.m_MinIntensity;
    }

    public String minIntensityTipText() {
        return "The minimum intensity to keep.";
    }

    public void setMaxIntensity(double value) {
        if (value > 0.0 || value == -1.0) {
            this.m_MaxIntensity = value;
            this.reset();
        } else {
            this.getLogger().severe(((Object)((Object)this)).getClass().getName() + ": only positive numbers or -1 are allowed for the maximum intensity " + "(provided: " + value + ")!");
        }
    }

    public double getMaxIntensity() {
        return this.m_MaxIntensity;
    }

    public String maxIntensityTipText() {
        return "The maximum intensity to keep.";
    }

    @Override
    protected void checkHeader(Heatmap data) {
        int size = this.m_OutputHeader.numAttributes();
        if (this.m_AddDatabaseID) {
            --size;
        }
        if (size != this.m_Fields.length + data.size()) {
            throw new IllegalStateException("Number of fields+heatmap points and output attributes differ (" + data + "): " + this.m_Fields.length + "+" + data.size() + " != " + size);
        }
    }

    protected void generateHeader(Heatmap data) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < data.size(); ++i) {
            atts.add(new Attribute("Intensity-" + (i + 1)));
        }
        StringBuilder name = new StringBuilder();
        for (Field target : this.m_Fields) {
            atts.add(this.createAttribute(target, name));
        }
        this.m_OutputHeader = new Instances(((Object)((Object)this)).getClass().getName() + "-" + name.toString(), atts, 0);
    }

    protected Instance generateOutput(Heatmap data) {
        int i;
        double[] values = new double[this.m_OutputHeader.numAttributes()];
        for (i = 0; i < values.length; ++i) {
            values[i] = Utils.missingValue();
        }
        int offset = 0;
        if (this.m_AddDatabaseID) {
            ++offset;
        }
        double min = this.m_MinIntensity == -1.0 ? data.getMin() : this.m_MinIntensity;
        double max = this.m_MaxIntensity == -1.0 ? data.getMax() : this.m_MaxIntensity;
        for (i = 0; i < data.size(); ++i) {
            values[offset + i] = Math.min(Math.max(data.get(i), min), max);
        }
        this.addFields(data, values);
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_OutputHeader);
        return result;
    }
}

