/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.AbstractDataProcessorTestCase;
import adams.data.container.DataContainer;
import adams.data.heatmap.Heatmap;
import adams.data.instances.AbstractInstanceGenerator;
import adams.data.io.input.SpreadSheetHeatmapReader;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.util.List;
import weka.core.Instance;

public abstract class AbstractInstanceGeneratorTestCase
extends AbstractDataProcessorTestCase<AbstractInstanceGenerator, Heatmap, Instance> {
    public AbstractInstanceGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/instances/data");
    }

    protected Instance process(Heatmap data, AbstractInstanceGenerator scheme) {
        return scheme.generate((DataContainer)data);
    }

    protected Heatmap load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        SpreadSheetHeatmapReader reader = new SpreadSheetHeatmapReader();
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        if (result.size() > 0) {
            return (Heatmap)result.get(0);
        }
        return null;
    }

    protected boolean save(Instance data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data, (boolean)false);
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractInstanceGenerator[] getRegressionSetups();
}

