/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.filter.AbstractHeatmapFilterTestCase;
import adams.data.filter.HeatmapSubtractField;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class HeatmapSubtractFieldTest
extends AbstractHeatmapFilterTestCase {
    public static final String FIELD = "Blah";

    public HeatmapSubtractFieldTest(String name) {
        super(name);
    }

    @Override
    protected Heatmap load(String filename) {
        Heatmap result = super.load(filename);
        if (result != null) {
            result.getReport().addField((AbstractField)new Field(FIELD, DataType.NUMERIC));
            result.getReport().setNumericValue(FIELD, 0.5);
        }
        return result;
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"simple.csv"};
    }

    protected AbstractFilter[] getRegressionSetups() {
        HeatmapSubtractField[] result = new HeatmapSubtractField[]{new HeatmapSubtractField()};
        result[0].setField(new Field(FIELD, DataType.NUMERIC));
        return result;
    }

    public static Test suite() {
        return new TestSuite(HeatmapSubtractFieldTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        HeatmapSubtractFieldTest.runTest((Test)HeatmapSubtractFieldTest.suite());
    }
}

