/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featuregenerator;

import adams.data.container.DataContainer;
import adams.data.featuregenerator.AbstractDatabaseConnectionFeatureGenerator;
import adams.data.featuregenerator.AbstractFeatureGenerator;
import adams.data.featuregenerator.PassThrough;
import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class FilteredFeatureGenerator
extends AbstractDatabaseConnectionFeatureGenerator {
    private static final long serialVersionUID = 8646651693938769168L;
    protected AbstractFilter m_Filter;
    protected AbstractFeatureGenerator m_Generator;

    public String globalInfo() {
        return "This feature generator first pushes the data through the provided data filter before applying the actual feature generator. The updated data obtained from the feature generator then replaces the report of the original data container.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new adams.data.filter.PassThrough());
        this.m_OptionManager.add("generator", "generator", (Object)new PassThrough());
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setFilter(AbstractFilter value) {
        this.m_Filter = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to apply to the heatmap before pushing it through the feature generator.";
    }

    public void setGenerator(AbstractFeatureGenerator value) {
        this.m_Generator = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractFeatureGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to apply to the filtered data.";
    }

    @Override
    protected void updateDatabaseConnection() {
        if (this.m_Filter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)this.m_Filter).setDatabaseConnection(this.getDatabaseConnection());
        }
        if (this.m_Generator instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)this.m_Generator).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    @Override
    protected Heatmap processData(Heatmap data) {
        Heatmap filtered = (Heatmap)this.m_Filter.filter((DataContainer)data);
        filtered = this.m_Generator.generate(filtered);
        Heatmap result = data.getClone();
        result.setReport(filtered.getReport().getClone());
        return result;
    }
}

