/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.filter.AbstractPreFilter;
import adams.data.filter.HeatmapCentroid;
import adams.data.filter.HeatmapThreshold;
import adams.data.filter.heatmapcrop.CropToCentroid;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

@Deprecated
public class HeatmapCropToCentroid
extends AbstractPreFilter<Heatmap> {
    private static final long serialVersionUID = 2270876952032422552L;
    public static final String CROP_LEFT = "Crop.Left";
    public static final String CROP_TOP = "Crop.Top";
    public static final String CROP_RIGHT = "Crop.Right";
    public static final String CROP_BOTTOM = "Crop.Bottom";
    protected int m_Height;
    protected int m_Width;
    protected HeatmapCentroid m_Centroid;

    public String globalInfo() {
        return "Generates a cropped heatmap centered around the centroid calculated on the pre-filtered data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
        this.m_OptionManager.add("centroid", "centroid", (Object)new HeatmapCentroid());
    }

    protected AbstractFilter getDefaultFilter() {
        return new HeatmapThreshold();
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height must be > 0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the cropped region.";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width must be > 0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the cropped region.";
    }

    public void setCentroid(HeatmapCentroid value) {
        this.m_Centroid = value;
        this.reset();
    }

    public HeatmapCentroid getCentroid() {
        return this.m_Centroid;
    }

    public String centroidTipText() {
        return "The centroid filter to use.";
    }

    protected Heatmap processData(Heatmap filtered, Heatmap original) {
        HeatmapCentroid centroid = (HeatmapCentroid)this.m_Centroid.shallowCopy(true);
        Heatmap centered = (Heatmap)centroid.filter(filtered);
        centroid.destroy();
        int c_x = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.X", DataType.NUMERIC)));
        int c_y = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.Y", DataType.NUMERIC)));
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Centroid location (y,x): " + c_y + "," + c_x);
        }
        Heatmap result = CropToCentroid.crop(original, c_y, c_x, this.m_Height, this.m_Width);
        return result;
    }
}

