/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.IntArrayMatrixView;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.JAIImageReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;

public class SimpleImageHeatmapReader
extends AbstractHeatmapReader {
    private static final long serialVersionUID = -2903357410192470809L;
    protected AbstractImageReader m_Reader;

    public String globalInfo() {
        return "Reads an image with the specified reader and turns the grayscale version of the image into a heatmap.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new JAIImageReader());
    }

    public void setReader(AbstractImageReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractImageReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The image reader to use.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public String getFormatDescription() {
        return "Simple image heatmap reader";
    }

    public String[] getFormatExtensions() {
        if (this.m_Reader == null) {
            return new String[]{"*"};
        }
        return this.m_Reader.getFormatExtensions();
    }

    protected void readData() {
        Heatmap map;
        try {
            AbstractImageContainer cont = this.m_Reader.read(this.m_Input);
            BufferedImage image = BufferedImageHelper.convert((BufferedImage)cont.toBufferedImage(), (int)10);
            IntArrayMatrixView matrix = BufferedImageHelper.getPixelMatrix((BufferedImage)image);
            map = new Heatmap(matrix.getHeight(), matrix.getWidth());
            for (int y = 0; y < matrix.getHeight(); ++y) {
                for (int x = 0; x < matrix.getWidth(); ++x) {
                    int[] rgba = matrix.getRGBA(x, y);
                    map.set(y, x, rgba[0]);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read heatmap from '" + this.m_Input + "'!", e);
            map = null;
        }
        if (map != null) {
            this.m_ReadData.add(map);
        }
    }
}

